/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A*1  T40   R SMALL_EIFFEL 40
A*1  T23   R STD_OUTPUT 23
A 1  T6    E BOOLEAN 6
A 1  T2    E INTEGER 2
A 1  T3    E CHARACTER 3
A*1  T39   R FIXED_ARRAY[STRING] 39
A 1  T8    E POINTER 8
A*1  T35   R STD_ERROR 35
A*1  T21   R ECHO 21
A*1  T29   R STD_FILE_READ 29
A*1  T37   R RUN_CONTROL 37
A*1  T28   R SYSTEM_TOOLS 28
A*1  T7    R STRING 7
A 1  T34   E NATIVE_ARRAY[STRING] 34
A*1  T31   R ARRAY[STRING] 31
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T36   E FILE_TOOLS 36
A*1  T10   R COMPILE 10
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef void*T40;
typedef void*T23;
typedef struct S39 T39;
typedef void*T35;
typedef struct S21 T21;
typedef struct S29 T29;
typedef struct S37 T37;
typedef struct S28 T28;
typedef struct S7 T7;
typedef struct S31 T31;
typedef int T36;
typedef struct S10 T10;

/*C Header Pass 2 :*/
typedef T0**T34;
typedef T3*T9;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
extern T40 M40;
extern T23 M23;
struct S39{T34 _storage;T2 _capacity;T2 _upper;};
extern T39 M39;
extern T35 M35;
struct S21{T6 _verbose;};
extern T21 M21;
struct S29{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T29 M29;
struct S37{T0* _root_class;T0* _root_procedure_memory;};
extern T37 M37;
struct S28{T0* _system_name;T0* _sys_directory;T0* _bin_directory;T0* _c_compiler;};
extern T28 M28;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S31{T34 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T31 M31;
extern T36 M36;
struct S10{T6 _exec_clean_command;};
extern T10 M10;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T3 r3to_lower(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3is_digit(T3 C);
T3 r3to_upper(T3 C);
T6 r34equal_like(T0* a1,T0* a2);
void r34set_all_with(T34 C,T0* a1,T2 a2);
T2 r34index_of(T34 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
void r7to_lower(T7* C);
T6 r7is_equal(T7* C,T0* a1);
void r7remove_first(T7* C,T2 a1);
T3 r7last(T7* C);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
T8 r7to_external(T7* C);
void r7copy(T7* C,T0* a1);
T6 r7has_prefix(T7* C,T0* a1);
void r7remove_last(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r39make(T39* C,T2 a1);
T2 r31index_of(T31* C,T0* a1);
T6 r31valid_index(T31* C,T2 a1);
T6 r31has(T31* C,T0* a1);
T0* r31item(T31* C,T2 a1);
void r23put_string(T23* C,T0* a1);
void r35put_string(T35* C,T0* a1);
extern T36 oBC1file_tools;
void r21put_string(T21* C,T0* a1);
void r21sfr_connect_or_exit(T21* C,T0* a1,T0* a2);
void r21sfr_connect(T21* C,T0* a1,T0* a2);
T0* r21read_word_in(T21* C,T0* a1);
void r21w_put_string(T0* a1);
void r21system(T0* a1);
void r21call_system(T21* C,T0* a1);
T6 r21file_exists(T0* a1);
void r21file_removing(T21* C,T0* a1);
void r21w_put_character(T3 a1);
extern T0*oBC1std_error;
extern T0*oBC1std_output;
void r29disconnect(T29* C);
void r29read_line_in(T29* C,T0* a1);
T6 r29end_of_input(T29* C);
extern T0*oBC30last_string;
void r29read_character(T29* C);
void r29read_line(T29* C);
void r29read_word(T29* C);
void r29connect_to(T29* C,T0* a1);
void r29skip_separators(T29* C);
void r37compute_root_class(T37* C,T0* a1);
extern T0*oBC12tmp_file_read;
void r28cygnus_bug(T28* C,T0* a1,T0* a2);
extern T0*oBC28compiler_list;
extern int fBC28object_suffix;
extern T0*oBC28object_suffix;
T0* r28object_suffix(T28* C);
void r28make(T28* C);
extern T0*oBC12echo;
void r28bad_use_exit(T28* C,T0* a1);
extern T0*oBC12run_control;
void r28set_c_compiler(T28* C,T0* a1);
extern int fBC28make_suffix;
extern T0*oBC28make_suffix;
T0* r28make_suffix(T28* C);
extern int fBC28x_suffix;
extern T0*oBC28x_suffix;
T0* r28x_suffix(T28* C);
void r28show_compiler_list_then_exit(T28* C);
T2 r28extra_arg(T28* C,T0* a1,T2 a2,T0* a3);
T6 r28backslash_separator(T28* C);
T0* r28get_environment_variable(T28* C,T0* a1);
T0* r28remove_make_script(T28* C);
extern T0*oBC28system_list;
T6 r28slash_separator(T28* C);
void r28list_add(T0* a1,T0* a2);
void r28add_directory(T28* C,T0* a1,T0* a2);
void r28parent_directory(T28* C,T0* a1);
T0* r28path_h(T28* C);
void r28command_path_in(T28* C,T0* a1,T0* a2);
T6 r36is_readable(T0* a1);
extern T0*oBC36std_fr1;
void r36delete(int C,T0* a1);
void r10compile_to_c_pass_argument(T0* a1);
extern T0*oBC10one_arg_flags;
extern T0*oBC12small_eiffel;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
void r10search_for_cc_flag(T2 a1);
void r10make(T10* C);
extern T0*oBC10command;
T0* r10argument(T2 a1);
void r10check_for_root_class(T10* C);
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r10system_tools(void);
T6 r10is_flag_verbose(T0* a1);
T6 r10is_flag_version(T10* C,T0* a1);
extern T0*oBC10make_file;
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 41
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms28_0aaaa;
extern T7*ms28_1428a;
extern T7*ms28_0aaaaa;
extern T7*ms28_0;
extern T7*ms12_290;
extern T7*ms12_300;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms28_270;
extern T7*ms28_210;
extern T7*ms28_690;
extern T7*ms10_312;
extern T7*ms28_242;
extern T7*ms28_903;
extern T7*ms12_294;
extern T7*ms28_414;
extern T7*ms28_314;
extern T7*ms28_0aaaaaa;
extern T7*ms28_285;
extern T7*ms28_306;
extern T7*ms28_286;
extern T7*ms28_396;
extern T7*ms28_636;
extern T7*ms28_948;
extern T7*ms11_729;
extern T7*ms28_428;
extern T7*ms28_738;
extern T7*ms13_939;
extern T7*ms10_6660;
extern T7*ms10_8720;
extern T7*ms21_8610;
extern T7*ms13_3720;
extern T7*ms28_8280;
extern T7*ms10_8701;
extern T7*ms28_2300;
extern T7*ms28_0a;
extern T7*ms10_6582;
extern T7*ms10_8092;
extern T7*ms12_1592;
extern T7*ms28_6162;
extern T7*ms28_4542;
extern T7*ms28_1032;
extern T7*ms28_1472;
extern T7*ms28_8092;
extern T7*ms13_1053;
extern T7*ms11_2424;
extern T7*ms28_1444;
extern T7*ms28_1484;
extern T7*ms28_1044;
extern T7*ms11_2575;
extern T7*ms28_1985;
extern T7*ms28_2395;
extern T7*ms13_2976;
extern T7*ms28_1076;
extern T7*ms28_9226;
extern T7*ms28_1316;
extern T7*ms28_1296;
extern T7*ms28_1428;
extern T7*ms21_6929;
extern T7*ms10_12180;
extern T7*ms11_24020;
extern T7*ms28_46640;
extern T7*ms28_41310;
extern T7*ms28_15800;
extern T7*ms28_26180;
extern T7*ms28_38280;
extern T7*ms28_31980;
extern T7*ms28_19880;
extern T7*ms28_10010;
extern T7*ms28_43761;
extern T7*ms11_10272;
extern T7*ms28_29002;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms11_10984;
extern T7*ms21_12714;
extern T7*ms28_22824;
extern T7*ms10_38385;
extern T7*ms10_20216;
extern T7*ms21_72306;
extern T7*ms28_0aa;
extern T7*ms28_13776;
extern T7*ms28_12816;
extern T7*ms28_18117;
extern T7*ms28_48887;
extern T7*ms11_20688;
extern T7*ms11_34188;
extern T7*ms21_26208;
extern T7*ms21_25179;
extern T7*ms28_31119;
extern T7*ms10_166100;
extern T7*ms12_581900;
extern T7*ms40_802392;
extern T7*ms28_716872;
extern T7*ms28_131716;
extern T7*ms28_848426;
extern T7*ms28_225848;
extern T7*ms28_242a;
extern T7*ms28_0aaa;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void*se_ma31(int argc,...);

