--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class WRITABLE_ATTRIBUTE
   --
   -- For instance variables (ordinary attribute).
   --

inherit ATTRIBUTE;

creation make

feature {NONE}

   make(n: like names; t: like result_type) is
      require
         n /= Void;
         t /= Void
      do
         make_e_feature(n);
         result_type := t;
      ensure
         names = n;
         result_type = t
      end;

feature

   to_run_feature(t: TYPE; fn: FEATURE_NAME): RUN_FEATURE_2 is
      do
         !!Result.make(t,fn,Current);
      end;

feature {C_PRETTY_PRINTER}

   stupid_switch(up_rf: RUN_FEATURE; r: ARRAY[RUN_CLASS]): BOOLEAN is
      local
         rf2a, rf2b: RUN_FEATURE_2;
         offseta, offsetb: INTEGER;
         rta, rtb: TYPE;
         i: INTEGER;
         rc: RUN_CLASS;
      do
         from
            Result := true;
            i := r.upper;
         until
            not Result or else i = 0
         loop
            rc := r.item(i);
            rf2b ?= rc.dynamic(up_rf);
            if rf2b /= Void then
               offsetb := rc.offset_of(rf2b);
            end;
            if rf2a = Void then
               rf2a := rf2b;
               offseta := offsetb;
            end;
            if rf2b = Void then
               Result := false;
            elseif rf2a.name.to_string = rf2b.name.to_string then
               Result := offseta = offsetb;
               if Result then
                  rta := rf2a.result_type;
                  rtb := rf2b.result_type;
                  if rta.is_reference then
                     Result := rtb.is_reference;
                  elseif rta.run_time_mark = rtb.run_time_mark then
                  elseif rta.is_native_array then
                     if rta.generic_list.first.is_reference then
                        Result := rtb.generic_list.first.is_reference;
                     end;
                  else
                     Result := false;
                  end;
               end
            else
               Result := false;
            end;
            i := i - 1;
         end;
         if Result then
            cpp.put_comment("SSWA1");
         end;
      end;

feature {NONE}

   pretty_tail is
      do
      end;

end -- WRITABLE_ATTRIBUTE

