/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78Beta#1)--
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))

/* --- Mangling Table Start ---
A 1  T2135 E NATIVE_ARRAY[STRING] 2135
A 1  T660  R DIRECTORY 660
A 1  T474  R BOOLEAN_REF 474
A 1  T1405 R BASIC_DIRECTORY 1405
A 1  T701  R EXAMPLE01 701
A 1  T2    E INTEGER 2
D 10 T98   R ANY 1405,660,714,528,2074,878,7,1886,701,474
A 1  T3    E CHARACTER 3
A 1  T1886 R FIXED_ARRAY[STRING] 1886
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T7    R STRING 7
A 2  T878  R STD_OUTPUT 878,2074
A 1  T2074 R STD_INPUT_OUTPUT 2074
A 1  T8    E POINTER 8
A 1  T714  R CHARACTER_REF 714
A 1  T6    E BOOLEAN 6
A 1  T528  R INTEGER_REF 528
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S660 T660;
typedef struct S474 T474;
typedef struct S1405 T1405;
typedef struct S701 T701;
typedef struct S1886 T1886;
typedef struct S7 T7;
typedef struct S878 T878;
typedef struct S2074 T2074;
typedef struct S714 T714;
typedef struct S528 T528;

/*C Header Pass 2 :*/
typedef T0**T2135;
typedef T3*T9;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
void se_prinT2135(T2135*o);
struct S660{int id;T0* _basic_directory;T6 _is_connected;};
extern T660 M660;
void se_prinT660(T660**o);
struct S474{int id;T6 _item;};
extern T474 M474;
void se_prinT474(T474**o);
struct S1405{int id;T0* _path;T0* _name_list;};
extern T1405 M1405;
void se_prinT1405(T1405**o);
struct S701{int id;};
extern T701 M701;
void se_prinT701(T701**o);
struct S1886{int id;T2135 _storage;T2 _capacity;T2 _upper;};
extern T1886 M1886;
void se_prinT1886(T1886**o);
void se_prinT9(T9*o);
struct S7{int id;T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S878{int id;};
extern T878 M878;
void se_prinT878(T878**o);
struct S2074{int id;};
extern T2074 M2074;
void se_prinT2074(T2074**o);
struct S714{int id;T3 _item;};
extern T714 M714;
void se_prinT714(T714**o);
struct S528{int id;T2 _item;};
extern T528 M528;
void se_prinT528(T528**o);
T7*se_ms(int c,char*e);
T7*e2s(char*e);
char*s2e(T7*s);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (no_check.h) is automatically included when `run_control.no_check'
  is true (ie. all modes ecxept mode -boost).
*/
#define SE_NO_CHECK 1

/*
  To be able to print a stack frame in a human readable format :
*/
typedef struct _se_frame_descriptor se_frame_descriptor;
struct _se_frame_descriptor {
  char* name;
  int use_current;
  int local_count; /* Number of C variable to print. */
  char* local_format; /* Format information. */
  int assertion_flag; /* 1 when assertions can be checked. */ 
};

/*
  To keep the track of execution in order to be able to print a 
  dump when things goes wrong :
*/
typedef struct _se_dump_stack se_dump_stack;
struct _se_dump_stack {
  se_frame_descriptor* fd;
  void** current; /* NULL when not used. */
  int l; /* Current execution line. */
  int c; /* Current execution column. */
  int f; /* File path index (base class id). */
  se_dump_stack* caller; /* Back to the caller. */
  void*** locals;
};
extern se_dump_stack* se_dst;
void se_print_run_time_stack(void);
void se_print_one_frame(se_dump_stack*ds);
void se_core_dump(char *msg);

extern int se_rspf;
extern int se_require_uppermost_flag;
extern int se_require_last_result;
int se_rci(void*C);
void error0(char*m);
void error1(char*m,int l,int c,int f);
void error2(T0*o,int l,int c,int f);
T0* vc(void*o,int l,int c,int f);
T0* ci(int id,void*o,int l,int c,int f);
void ac_req(int v);
void ac_ens(int v);
void ac_inv(int v);
void ac_liv(int v);
void ac_insp(int v);
int ac_lvc(int lc,int lv1,int lv2);
void ac_civ(int v);
void se_evobt(void*o,int l,int c,int f);
void sigrsp(int sig);
void se_gc_check_id(void*o,int id);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (trace.h) is automatically included when `run_control.no_check' is
  true (ie. all modes ecxept -boost).
  This file comes after no_check.[hc] to implements the -trace flag as well as
  some other printing stuff.
*/

void se_prinT0(T0**o);
void se_prinT2(T2*o);
void se_prinT3(T3*o);
void se_prinT4(T4*o);
void se_prinT5(T5*o);
void se_prinT6(T6*o);
void se_prinT7(T7**o);
void se_prinT8(T8*o);
void se_trace(se_dump_stack*ds,int l,int c,int f);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (basic_directory.h) is automatically included when some external
  "SmallEiffel" feature of class BASIC_DIRECTORY is live.
*/
#include <dirent.h>
#include <unistd.h>

void* se_dir_open(void* path);
void* se_dir_name(void* dirstream);
void* se_dir_next(void* dirstream);
void* se_dir_gcwd(int unused);
#define FSOC_SIZE 8192
#define RSOC_SIZE 32768
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/* This file is automatically included when the Garbage Collector
   is used (default, unless option -no_gc has been selected).
*/
#define SE_GC_LIB 1

#define RSOH_UNMARKED 15253     
#define RSOH_MARKED 0
#define RSOH_FREE 1


#define FSOH_UNMARKED 1
#define FSOH_MARKED 0

/* To codify the state and the type of some Memory Chunk, we are 
   using the following definitions :
*/
#define FSO_FREE_CHUNK  (-2)
#define RSO_FREE_CHUNK  (-1)
#define RSO_USED_CHUNK  ( 0)
#define FSO_STORE_CHUNK ( 1)
#define FSO_USED_CHUNK  ( 2)
#define FREE_CHUNK(x) ((x)<0)

/* Minimum size for a store area in a ReSizable Objects Chunk :
 */
#define RSOC_MIN_STORE 512

typedef struct s_mch mch; /* Memory Chunk Header. */
typedef struct s_fsoc fsoc; /* Fixed Size Objects Chunk. */
typedef union u_rsoh rsoh; /* ReSizable Object Header. */
typedef struct s_fll_rsoh fll_rsoh; 
typedef struct s_rsoc rsoc; /* ReSizable Objects Chunk. */
typedef struct s_na_env na_env; /* Native Array ENVironment. */


struct s_mch{ 
  int size; /* In number of bytes (actual argument of malloc).*/
  int state_type; /* One value in : RSO_USED_CHUNK, 
                     FREE_CHUNK, FSO_STORE_CHUNK, FSO_USED_CHUNK */
  void(*amfp)(mch*,void*); /* Align Mark Function Pointer. */
  void(*swfp)(mch*); /* SWeep Function Pointer. */
};

struct s_fsoc{
  mch header;
  fsoc* next;
  int count_minus_one;
  double first_object;
};

typedef struct _rso_header rso_header;

struct _rso_header{
    int size;
    int magic_flag;     /* RSOH_MARKED when used,
			   RSOH_FREE when free,
			   else RSOH_UNMARKED */
};

union u_rsoh{
  rso_header header;             
  double padding; 
  };

struct s_fll_rsoh {
  rso_header rsoh_field;
  fll_rsoh* nextflol;
};

struct s_rsoc{
  mch header;
  rsoc* next;
  fll_rsoh*free_list_of_large;
  na_env*nae;
  rsoh first_header;
};

struct s_na_env{
  int store_left;
  rsoh* store;
  rsoc*store_chunk;
  rsoc*chunk_list;
  void (*gc_mark)(T0*);
};

extern void**stack_bottom;
extern mch**gcmt;
extern int gcmt_max;
extern int gcmt_used;
extern fsoc*fsocfl;
extern rsoc*rsocfl;
extern int gc_is_off;
extern unsigned int fsoc_count;
extern unsigned int rsoc_count;
extern void*gcmt_tail_addr;

int na_rounded_size(int s);
void gc_sweep(void);
void gc_mark(void*p);
int gc_stack_size(void);
int garbage_delayed(void);
void gc_update_ceils(void);
fsoc*new_fsoc(void);
char*new_na(na_env*nae,int size);
void gcna_align_mark(rsoc*c,void*o);
int fsocfl_count(void);
int rsocfl_count(void);
extern unsigned int fsoc_count_ceil;
extern unsigned int rsoc_count_ceil;
extern unsigned int gc_start_count;
T6 r2in_range(se_dump_stack*caller,T2 C,T2 a1,T2 a2);
extern se_frame_descriptor f2in_range;
void r2append_in(se_dump_stack*caller,T2 C,T0* a1);
extern se_frame_descriptor f2append_in;
T3 r2digit(se_dump_stack*caller,T2 C);
extern se_frame_descriptor f2digit;
T6 r2divisible(se_dump_stack*caller,T2 a1);
extern se_frame_descriptor f2divisible;
T6 r3_px_6061(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_6061;
T6 r3_px_60(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_60;
T6 r3is_digit(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3is_digit;
T2 r3value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3value;
T6 r8is_null(se_dump_stack*caller,T8 C);
extern se_frame_descriptor f8is_null;
T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_or;
T6 r6_ix_not(se_dump_stack*caller,T6 C);
extern se_frame_descriptor f6_ix_not;
T6 r6_px_and(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_and;
T2135 r2135realloc(se_dump_stack*caller,T2135 C,T2 a1,T2 a2);
extern se_frame_descriptor f2135realloc;
T6 r2135is_not_null(se_dump_stack*caller,T2135 C);
extern se_frame_descriptor f2135is_not_null;
void r2135set_all_with(se_dump_stack*caller,T2135 C,T0* a1,T2 a2);
extern se_frame_descriptor f2135set_all_with;
T6 r2135equal_like(se_dump_stack*caller,T0* a1,T0* a2);
extern se_frame_descriptor f2135equal_like;
void r2135copy_from(se_dump_stack*caller,T2135 C,T2135 a1,T2 a2);
extern se_frame_descriptor f2135copy_from;
T6 r2135all_cleared(se_dump_stack*caller,T2135 C,T2 a1);
extern se_frame_descriptor f2135all_cleared;
T6 r2135memcmp(se_dump_stack*caller,T2135 C,T2135 a1,T2 a2);
extern se_frame_descriptor f2135memcmp;
T2 r2135index_of(se_dump_stack*caller,T2135 C,T0* a1,T2 a2);
extern se_frame_descriptor f2135index_of;
T6 r9fast_memcmp(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9fast_memcmp;
T9 r9realloc(se_dump_stack*caller,T9 C,T2 a1,T2 a2);
extern se_frame_descriptor f9realloc;
T6 r9is_not_null(se_dump_stack*caller,T9 C);
extern se_frame_descriptor f9is_not_null;
T6 r9fast_has(se_dump_stack*caller,T9 C,T3 a1,T2 a2);
extern se_frame_descriptor f9fast_has;
void r9copy_from(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9copy_from;
T6 r7standard_is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7standard_is_equal;
T8 r7to_external(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7to_external;
void r7from_external(se_dump_stack*caller,T7* C,T8 a1);
extern se_frame_descriptor f7from_external;
T6 r7has(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7has;
T6 r7is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7is_equal;
T3 r7item(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7item;
T6 r7valid_index(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7valid_index;
void r7make(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7make;
void r7extend(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7extend;
void r7from_external_copy(se_dump_stack*caller,T7* C,T8 a1);
extern se_frame_descriptor f7from_external_copy;
void r7clear(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7clear;
void r7swap(se_dump_stack*caller,T7* C,T2 a1,T2 a2);
extern se_frame_descriptor f7swap;
T6 r7empty(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7empty;
void r7put(se_dump_stack*caller,T7* C,T3 a1,T2 a2);
extern se_frame_descriptor f7put;
extern se_frame_descriptor se_ifd7;
T7*se_i7(se_dump_stack*caller,T7*C);
void r1886with_capacity(se_dump_stack*caller,T1886* C,T2 a1);
extern se_frame_descriptor f1886with_capacity;
T6 r1886standard_is_equal(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886standard_is_equal;
T6 r1886has(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886has;
void r1886clear_all(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886clear_all;
void r1886add_last(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886add_last;
T6 r1886is_equal(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886is_equal;
T0* r1886item(se_dump_stack*caller,T1886* C,T2 a1);
extern se_frame_descriptor f1886item;
void r1886set_all_with(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886set_all_with;
T6 r1886valid_index(se_dump_stack*caller,T1886* C,T2 a1);
extern se_frame_descriptor f1886valid_index;
T0* r1886last(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886last;
T2 r1886count(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886count;
void r1886make(se_dump_stack*caller,T1886* C,T2 a1);
extern se_frame_descriptor f1886make;
T6 r1886equal(se_dump_stack*caller,T1886* C,T0* a1,T0* a2);
extern se_frame_descriptor f1886equal;
void r1886clear(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886clear;
T6 r1886all_cleared(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886all_cleared;
T6 r1886empty(se_dump_stack*caller,T1886* C);
extern se_frame_descriptor f1886empty;
T2 r1886index_of(se_dump_stack*caller,T1886* C,T0* a1);
extern se_frame_descriptor f1886index_of;
void r1886put(se_dump_stack*caller,T1886* C,T0* a1,T2 a2);
extern se_frame_descriptor f1886put;
extern se_frame_descriptor se_ifd1886;
T1886*se_i1886(se_dump_stack*caller,T1886*C);
T6 r660standard_is_equal(se_dump_stack*caller,T660* C,T0* a1);
extern se_frame_descriptor f660standard_is_equal;
T6 r660has(se_dump_stack*caller,T660* C,T0* a1);
extern se_frame_descriptor f660has;
T0* r660path(se_dump_stack*caller,T660* C);
extern se_frame_descriptor f660path;
T6 r660is_equal(se_dump_stack*caller,T660* C,T0* a1);
extern se_frame_descriptor f660is_equal;
T6 r660valid_index(se_dump_stack*caller,T660* C,T2 a1);
extern se_frame_descriptor f660valid_index;
void r660connect_to(se_dump_stack*caller,T660* C,T0* a1);
extern se_frame_descriptor f660connect_to;
T2 r660count(se_dump_stack*caller,T660* C);
extern se_frame_descriptor f660count;
T0* r660name(se_dump_stack*caller,T660* C,T2 a1);
extern se_frame_descriptor f660name;
T6 r474standard_is_equal(se_dump_stack*caller,T474* C,T0* a1);
extern se_frame_descriptor f474standard_is_equal;
T6 r474is_equal(se_dump_stack*caller,T474* C,T0* a1);
extern se_frame_descriptor f474is_equal;
T6 r1405standard_is_equal(se_dump_stack*caller,T1405* C,T0* a1);
extern se_frame_descriptor f1405standard_is_equal;
T6 r1405has(se_dump_stack*caller,T1405* C,T0* a1);
extern se_frame_descriptor f1405has;
T6 r1405is_equal(se_dump_stack*caller,T1405* C,T0* a1);
extern se_frame_descriptor f1405is_equal;
T6 r1405valid_index(se_dump_stack*caller,T1405* C,T2 a1);
extern se_frame_descriptor f1405valid_index;
T6 r1405set_path(se_dump_stack*caller,T1405* C,T0* a1);
extern se_frame_descriptor f1405set_path;
T2 r1405count(se_dump_stack*caller,T1405* C);
extern se_frame_descriptor f1405count;
void r1405make(se_dump_stack*caller,T1405* C);
extern se_frame_descriptor f1405make;
T6 r1405update(se_dump_stack*caller,T1405* C);
extern se_frame_descriptor f1405update;
T2 r1405upper(se_dump_stack*caller,T1405* C);
extern se_frame_descriptor f1405upper;
T0* r1405name(se_dump_stack*caller,T1405* C,T2 a1);
extern se_frame_descriptor f1405name;
T6 r701standard_is_equal(se_dump_stack*caller,T701* C,T0* a1);
extern se_frame_descriptor f701standard_is_equal;
T6 r701is_equal(se_dump_stack*caller,T701* C,T0* a1);
extern se_frame_descriptor f701is_equal;
extern T0*oBC1std_output;
extern T0*oBC1io;
T0* r701argument(se_dump_stack*caller,T701* C,T2 a1);
extern se_frame_descriptor f701argument;
void r701make(se_dump_stack*caller,T701* C);
extern se_frame_descriptor f701make;
T2 r701argument_count(se_dump_stack*caller,T701* C);
extern se_frame_descriptor f701argument_count;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r701command_arguments(se_dump_stack*caller);
extern se_frame_descriptor f701command_arguments;
void r701list_directory(se_dump_stack*caller,T701* C,T0* a1);
extern se_frame_descriptor f701list_directory;
T6 r878standard_is_equal(se_dump_stack*caller,T878* C,T0* a1);
extern se_frame_descriptor f878standard_is_equal;
T6 r878is_equal(se_dump_stack*caller,T878* C,T0* a1);
extern se_frame_descriptor f878is_equal;
void r878put_string(se_dump_stack*caller,T878* C,T0* a1);
extern se_frame_descriptor f878put_string;
void r878make(se_dump_stack*caller,T878* C);
extern se_frame_descriptor f878make;
void r878put_character(se_dump_stack*caller,T878* C,T3 a1);
extern se_frame_descriptor f878put_character;
extern int fBC1070tmp_string;
extern T0*oBC1070tmp_string;
T0* r878tmp_string(se_dump_stack*caller);
extern se_frame_descriptor f878tmp_string;
void r878put_integer(se_dump_stack*caller,T878* C,T2 a1);
extern se_frame_descriptor f878put_integer;
T6 r2074standard_is_equal(se_dump_stack*caller,T2074* C,T0* a1);
extern se_frame_descriptor f2074standard_is_equal;
T6 r2074is_equal(se_dump_stack*caller,T2074* C,T0* a1);
extern se_frame_descriptor f2074is_equal;
void r2074put_string(se_dump_stack*caller,T2074* C,T0* a1);
extern se_frame_descriptor f2074put_string;
void r2074make(se_dump_stack*caller,T2074* C);
extern se_frame_descriptor f2074make;
void r2074put_character(se_dump_stack*caller,T2074* C,T3 a1);
extern se_frame_descriptor f2074put_character;
T0* r2074tmp_string(se_dump_stack*caller);
extern se_frame_descriptor f2074tmp_string;
void r2074put_integer(se_dump_stack*caller,T2074* C,T2 a1);
extern se_frame_descriptor f2074put_integer;
T6 r714standard_is_equal(se_dump_stack*caller,T714* C,T0* a1);
extern se_frame_descriptor f714standard_is_equal;
T6 r714is_equal(se_dump_stack*caller,T714* C,T0* a1);
extern se_frame_descriptor f714is_equal;
T6 r528standard_is_equal(se_dump_stack*caller,T528* C,T0* a1);
extern se_frame_descriptor f528standard_is_equal;
T6 r528is_equal(se_dump_stack*caller,T528* C,T0* a1);
extern se_frame_descriptor f528is_equal;
extern T701*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 2136
extern T7* g[];
extern T7* t[];
extern char* p[];
extern void(*se_prinT[2136])(void**);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms701_288aa;
extern T7*ms701_52800;
extern T7*ms701_31430;
extern T7*ms701_17488;
extern T7*ms2_8350;
extern T7*ms701_288a;
extern T7*ms701_36322;
extern T7*ms701_288;
void se_msi1(void);
void manifest_string_mark1(void);
void once_function_mark(void);
void gc_start(void);
extern na_env na_env2135;
typedef struct B660 gc660;
struct B660{T660 object;union {int flag;gc660*next;} header;};
extern gc660*store660;
extern int store_left660;
extern fsoc*store_chunk660;
extern gc660*gc_free660;
typedef struct B474 gc474;
struct B474{T474 object;union {int flag;gc474*next;} header;};
extern gc474*store474;
extern int store_left474;
extern fsoc*store_chunk474;
extern gc474*gc_free474;
typedef struct B1405 gc1405;
struct B1405{T1405 object;union {int flag;gc1405*next;} header;};
extern gc1405*store1405;
extern int store_left1405;
extern fsoc*store_chunk1405;
extern gc1405*gc_free1405;
typedef struct B701 gc701;
struct B701{T701 object;union {int flag;gc701*next;} header;};
extern gc701*store701;
extern int store_left701;
extern fsoc*store_chunk701;
extern gc701*gc_free701;
typedef struct B1886 gc1886;
struct B1886{T1886 object;union {int flag;gc1886*next;} header;};
extern gc1886*store1886;
extern int store_left1886;
extern fsoc*store_chunk1886;
extern gc1886*gc_free1886;
extern na_env na_env9;
typedef struct B7 gc7;
struct B7{T7 object;union {int flag;gc7*next;} header;};
extern gc7*store7;
extern int store_left7;
extern fsoc*store_chunk7;
extern gc7*gc_free7;
typedef struct B878 gc878;
struct B878{T878 object;union {int flag;gc878*next;} header;};
extern gc878*store878;
extern int store_left878;
extern fsoc*store_chunk878;
extern gc878*gc_free878;
typedef struct B2074 gc2074;
struct B2074{T2074 object;union {int flag;gc2074*next;} header;};
extern gc2074*store2074;
extern int store_left2074;
extern fsoc*store_chunk2074;
extern gc2074*gc_free2074;
typedef struct B714 gc714;
struct B714{T714 object;union {int flag;gc714*next;} header;};
extern gc714*store714;
extern int store_left714;
extern fsoc*store_chunk714;
extern gc714*gc_free714;
typedef struct B528 gc528;
struct B528{T528 object;union {int flag;gc528*next;} header;};
extern gc528*store528;
extern int store_left528;
extern fsoc*store_chunk528;
extern gc528*gc_free528;
void gc_mark2135(T2135 o);
T2135 new2135(int size);
void gc_sweep660(fsoc*c);
void gc_mark660(T660*o);
void gc_align_mark660(fsoc*c,gc660*p);
extern fsoc H660;
T660*new660(void);
void gc_sweep474(fsoc*c);
void gc_mark474(T474*o);
void gc_align_mark474(fsoc*c,gc474*p);
extern fsoc H474;
T474*new474(void);
void gc_sweep1405(fsoc*c);
void gc_mark1405(T1405*o);
void gc_align_mark1405(fsoc*c,gc1405*p);
extern fsoc H1405;
T1405*new1405(void);
void gc_sweep701(fsoc*c);
void gc_mark701(T701*o);
void gc_align_mark701(fsoc*c,gc701*p);
extern fsoc H701;
T701*new701(void);
void gc_sweep1886(fsoc*c);
void gc_mark1886(T1886*o);
void gc_align_mark1886(fsoc*c,gc1886*p);
extern fsoc H1886;
T1886*new1886(void);
void gc_mark9(T9 o);
T9 new9(int size);
void gc_sweep7(fsoc*c);
void gc_mark7(T7*o);
void gc_align_mark7(fsoc*c,gc7*p);
extern fsoc H7;
T7*new7(void);
void gc_sweep878(fsoc*c);
void gc_mark878(T878*o);
void gc_align_mark878(fsoc*c,gc878*p);
extern fsoc H878;
T878*new878(void);
void gc_sweep2074(fsoc*c);
void gc_mark2074(T2074*o);
void gc_align_mark2074(fsoc*c,gc2074*p);
extern fsoc H2074;
T2074*new2074(void);
void gc_sweep714(fsoc*c);
void gc_mark714(T714*o);
void gc_align_mark714(fsoc*c,gc714*p);
extern fsoc H714;
T714*new714(void);
void gc_sweep528(fsoc*c);
void gc_mark528(T528*o);
void gc_align_mark528(fsoc*c,gc528*p);
extern fsoc H528;
T528*new528(void);
void Xgc_mark878(T0*o);
T6 X98standard_is_equal(se_dump_stack*caller,int l,int c,int f, void *C,T0* a1);
T6 X98is_equal(se_dump_stack*caller,int l,int c,int f, void *C,T0* a1);
T6 X878standard_is_equal(se_dump_stack*caller,int l,int c,int f, void *C,T0* a1);
T6 X878is_equal(se_dump_stack*caller,int l,int c,int f, void *C,T0* a1);
void X878put_string(se_dump_stack*caller,int l,int c,int f, void *C,T0* a1);
void X878put_character(se_dump_stack*caller,int l,int c,int f, void *C,T3 a1);
void X878put_integer(se_dump_stack*caller,int l,int c,int f, void *C,T2 a1);

