/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (trace.c) is automatically included when `run_control.no_check' is
  true (ie. all modes ecxept -boost).
  This file comes after no_check.[hc] to implements the -trace flag as well as
  some other printing stuff.
*/

/* 
   To print object into the trace-stack :
*/
void se_prinT0(T0** o) {
  if (*o == NULL) {
    fprintf(SE_ERR,"Void");
  }
  else {
    fprintf(SE_ERR,"#%p",*o);
  }
}
void se_prinT2(T2* o) {
  fprintf(SE_ERR,"%d",*o);
}
void se_prinT3(T3* o) {
  fprintf(SE_ERR,"'%c'",*o);
}
void se_prinT4(T4* o) {
  fprintf(SE_ERR,"%f",((double)*o));
}
void se_prinT5(T5* o) {
  fprintf(SE_ERR,"%f",*o);
}
void se_prinT6(T6* o) {
  if (*o) {
    fprintf(SE_ERR,"true");
  }
  else {
    fprintf(SE_ERR,"false");
  }
}
void se_prinT7(T7** o) {
  if (*o == NULL) {
    fprintf(SE_ERR,"Void");
  }
  else {
    char*storage = (*o)->_storage;
    int count = (*o)->_count;
    int i = 0;
    fprintf(SE_ERR,"\"");
    while (i < count) {
      fprintf(SE_ERR,"%c",storage[i]);
      i++;
    }
    fprintf(SE_ERR,"\"");
  }
}
void se_prinT8(T8* o) {
  if (*o == NULL) {
    fprintf(SE_ERR,"NULL");
  }
  else {
    fprintf(SE_ERR,"POINTER#%p",*o);
  }
}

#ifndef SE_TRACE

void se_trace(se_dump_stack*ds,int l,int c,int f) {
  ds->l=l;
  ds->c=c;
  ds->f=f;
}

# endif

#ifdef SE_TRACE
/*
  Basic SmallEiffel step-by-step execution.
*/

static FILE* se_trace_file = NULL;
static int se_write_trace_flag = 0;
static int se_trace_ready_flag = 0;
static int se_step_by_step_flag = 1;

int get_answer(void) {
  int result = 0;
  char c = getc(stdin);
  if (c != '\n') {
    result = c;
  }
  while (c != '\n') {
    c = getc(stdin);
  }
  return result;
}

static void sedb_help_command(void) {
  printf("SmallEiffel debugger.\n");
  printf("List of classes of commands:\n");
  printf("   (h) Help.\n");
  printf("   (s) Stack view.\n");
  printf("   (q) Quit.\n");
  printf("   Return to see the current Eiffel source line.");
  printf("   \n");
  printf("Please, feel free to debug or to complete this simple\n");
  printf("step-by-step debugger (see source file in\n");
  printf("\"SmallEiffel/sys/runtime/trace.c\".\n");
}

static void sedb_show_source_line(int l,int c,int f) {
  static int f_memo = 0;
  if (p[f] == NULL) {
    printf("line %d column %d of ???\t\t",l,c);
  }
  else {
    FILE *file = fopen(p[f],"r");
    if (file != NULL) {
      int line = 1;
      int column = 1;
      char cc;
      while (line < l) {
	cc = fgetc(file);
	if (cc == '\n') {
	  line++;
	}
      }
      cc = fgetc(file);
      while (cc != '\n') {
	if (cc == '\t') {
	  printf("        ");
	  column+=7;
	}
	else {
	  fputc(cc,stdout);
	}
	cc = fgetc(file);
	column++;
      }
      while (column < 72) {
	fputc(' ',stdout);
	column++;
      }
      printf("l%dc%d ",l,c);
      if (f_memo != f) {
	printf(" %s ",p[f]);
      }
      f_memo = f;
      fclose(file);
    }
    else {
      printf("line %d column %d of %s\t\t",l,c,p[f]);
    }
  }
}

void se_trace(se_dump_stack*ds,int l,int c,int f) {
  static char cmd_memo = 1;
  static char cmd;
  ds->l=l;
  ds->c=c;
  ds->f=f;
  if (se_trace_ready_flag) {
    if (se_write_trace_flag) {
      fprintf(se_trace_file,"line %d column %d in %s\n",l,c,p[f]);
      fflush(se_trace_file);
    }
  next_command:
    if (se_step_by_step_flag) {
      if (cmd_memo != 0) {
	printf("(sedb) ");
      }
      fflush(stdout);
      cmd = get_answer();
      cmd_memo = cmd;
      if ((cmd == 'h') || (cmd == 'H') || (cmd == '?')) {
	sedb_help_command();
	goto next_command;
      }
      else if ((cmd == 's') || (cmd == 'S')) {
	se_print_run_time_stack();
	goto next_command;
      }
      else if ((cmd == 'q') || (cmd == 'Q')) {
	exit(1);
      }
      else if (cmd == 0) {
	sedb_show_source_line(l,c,f);
      }
      else {
	printf("Unknown command.\nTtype H for help\n");
	goto next_command;
      }
    }
  }
  else {
    se_trace_ready_flag = 1;
    printf("Write the execution trace in \"trace.se\" file (y/n) ? [n]");
    fflush(stdout);
    if (get_answer() == 'y') {
      se_write_trace_flag = 1;
      se_trace_file = fopen("trace.se","w");
    }
    printf("Step-by-step execution (y/n) ? [y]");
    fflush(stdout);
    if (get_answer() == 'n') {
      se_step_by_step_flag = 0;
    }
    else {
	sedb_help_command();
    }
  }
}
# endif
