#
# TCL Library for tkcvs
#

#
# $Id: workdir.tcl,v 1.39.2.29 1999/10/27 07:11:02 dorothyr Exp $
#
# Current working directory display.  Handles all of the functions
# concerned with navigating about the current directory on the main
# window.
#

# Note that the mark canvas no longer exists in this revision of the
# code.  This is because Tk 4.0 supports non-adjacent selections in
# listbox widgets, and so the code is no longer necessary.  It still
# exists on a development branch in case it is needed later.

set indexPrefix "^"
set filenamePrefix "!"

proc workdir_setup {} {
  global cwd
  global module_dir
  global cvscfg
  global TOOLTIPS_OFF
  global current_tagname
  global feedback

  set pid [pid]

  frame .top -relief groove -border 2
  frame .cleft     
  frame .center
  frame .cright    
  frame .crbottom  
  frame .clbottom  
    
  frame .top_left  
  frame .top_right 
  frame .bottom  -relief groove -border 2
  frame .bottom1
  frame .bottom2
  frame .bottom1label
  frame .bottom2label
  # If we have text buttons, groove the whole frame and not its subs
  if {$cvscfg(buttonstyle) == "Text"} {
    frame .bottom1workspace -relief groove -border 2
    frame .dirfuncs
    frame .cvsfuncs
    frame .modfuncs
  } else {
    frame .bottom1workspace
    frame .dirfuncs -relief groove -bd 2
    frame .cvsfuncs -relief groove -bd 2
    frame .modfuncs -relief groove -bd 2
  }

  pack .top                           -side top    -fill x
  pack .top_left         -in .top     -side left   
  pack .top_right        -in .top     -side right  -fill x -expand yes
  pack .center                        -side left   -fill both -expand yes

  pack .bottom           -in .center  -side bottom -fill x
  pack .bottom1          -in .bottom  -side top    -fill x
  pack .bottom1label     -in .bottom1 -side top    -fill x    -expand yes
  pack .bottom1workspace -in .bottom1 -side bottom -fill both -expand yes
  pack .bottom2          -in .bottom  -side bottom -fill x
  pack .bottom2label     -in .bottom2 -side top    -fill x    -expand yes

  pack .cleft            -in .center  -side left   -fill both -expand yes
  pack .cright           -in .center  -side right  -fill both -expand yes
  pack .crbottom         -in .cright  -side bottom -fill both -expand yes    
  pack .clbottom         -in .cleft   -side bottom -fill both -expand yes
    
  #
  # Top section of the screen ("commentary").
  #

  label .lcwd        -text "Current Directory" -anchor w
  label .lmodule     -text "Module Location"   -anchor w
  label .ltagname    -text "Directory Tag"     -anchor w

  entry .tcwd     -textvariable cwd         -relief sunken 
  label .trep     -textvariable cvscfg(cvsroot)  -anchor w
  label .tmodule  -textvariable module_dir  -anchor w
  label .ttagname -textvariable current_tagname -anchor w \
    -relief groove -border 2
  bind .tcwd        <Return> {change_dir $cwd}

  #
  # The central portion of the main screen.  This is where all of the
  # files and their statuses (for CVS 1.3 and later) are listed.
  #
  listbox   .file_list   -yscroll {.scroll set} \
    -relief sunken -width 0 -height $cvscfg(y_size) -setgrid yes \
    -selectmode extended
  listbox   .status_list -yscroll {.scroll set} \
    -relief sunken -width 0 -height $cvscfg(y_size) -setgrid yes
  listbox   .tag_list -yscroll {.scroll set} \
    -relief sunken -width 0 -height $cvscfg(y_size) -setgrid yes
  scrollbar .scroll  -command {workdir_scroll} \
    -relief sunken
        
  # Mouse button bindings need some work; i.e., there should be a richer set.
  bind .file_list   <Double-Button-1> \
    { workdir_edit_file [workdir_list_files] }
  bind .file_list   <Button-2>        \
    { nop }
  bind .file_list   <ButtonRelease-3> \
    { nop }

  bind .status_list <Double-Button-1> { nop }
  bind .status_list <ButtonRelease-1> { nop }
  bind .status_list <1>               { nop }
  bind .status_list <2>               { nop }
  bind .status_list <Any-B1-Motion>   { nop }
  bind .status_list <Any-B2-Motion>   { nop }
  bind .status_list <Any-B3-Motion>   { nop }
  
  #
  # Packing for the top two sections.
  #
  pack .lcwd     -in .top_left  -side top   -fill x -pady 3
  pack .lmodule  -in .top_left  -side top   -fill x
  pack .tcwd     -in .top_right -side top   -fill x -pady 3
  pack .tmodule  -in .top_right -side top   -fill x -pady 1
  pack .ltagname -in .top_left  -side top   -fill x
  pack .ttagname -in .top_right -side top   -fill x -pady 1
    
  pack .file_list   -in .clbottom  -side left  -fill both -expand yes
  pack .status_list -in .crbottom  -side left  -fill both -expand yes
  pack .tag_list    -in .crbottom  -side left  -fill both -expand yes
  pack .scroll      -in .crbottom  -side right -fill y    -expand yes -padx 2 
    
  #
  # Informational labels on bottom
  #
  label .lfilter     -text "Workspace Filter:" -anchor w
  label .lignore     -text "Ignore:"           -anchor w
  entry .tfilter  -textvariable cvscfg(file_filter) -relief sunken 
  entry .tignore  -textvariable cvscfg(ignore_file_filter) -relief sunken
  bind  .tfilter        <Return> {setup_dir}
  bind  .tignore        <Return> {setup_dir}

  #
  # Action buttons along the bottom of the screen.
  #
  button .bcheck        -relief raised \
    -command cvs_check
  button .bview_files   -relief raised \
    -command { workdir_view_file [workdir_list_files] }
  button .bedit_files   -relief raised \
    -command { workdir_edit_file [workdir_list_files] }
  button .bdelete_file  -relief raised \
    -command { workdir_delete_file [workdir_list_files] }
  button .bclear        -relief raised \
    -command { .file_list select clear 0 end }
  button .brefresh      -relief raised \
    -command setup_dir
  button .blogfile      -relief raised \
    -command { eval cvs_logcanvas [workdir_list_files] }
  button .badd_files    -relief raised \
    -command { cvs_add [workdir_list_files] }
  button .bremove       -relief raised \
    -command {cvs_remove [workdir_list_files] }
  button .bdiff         -relief raised \
    -command { eval cvs_diff [workdir_list_files] } 
  button .bcheckin      -relief raised \
    -command commit_run
  button .bupdate       -relief raised \
    -command { cvs_update "BASE" "Normal" "Remove" "No" " " [workdir_list_files] }
  button .bmodbrowse    -relief raised \
    -command checkout_run
  button .bimport       -relief raised \
    -command import_run
  button .bquit         -relief raised \
    -command {exit_cleanup}


  if {$cvscfg(buttonstyle) == "Text"} {
    .bcheck        configure -padx 0 -pady 0 -text "Check"
    .bview_files   configure -padx 0 -pady 0 -text "View"
    .bedit_files   configure -padx 0 -pady 0 -text "Edit"
    .bdelete_file  configure -padx 0 -pady 0 -text "Delete"
    .bclear        configure -padx 0 -pady 0 -text "Clear"
    .brefresh      configure -padx 0 -pady 0 -text "Refresh"
    .blogfile      configure -padx 0 -pady 0 -text "Log Browse"
    .badd_files    configure -padx 0 -pady 0 -text "Add"
    .bremove       configure -padx 0 -pady 0 -text "Remove"
    .bcheckin      configure -padx 0 -pady 0 -text "Check In"
    .bupdate       configure -padx 0 -pady 0 -text "Update"
    .bdiff         configure -padx 0 -pady 0 -text "Diff"
    .bmodbrowse    configure -padx 0 -pady 0 -text "Module Browse"
    .bimport       configure -padx 0 -pady 0 -text "Import"
  } else {
    image create photo Check -format gif -file $cvscfg(bitmapdir)/check.gif
    image create photo Notebook -format gif -file $cvscfg(bitmapdir)/notebook.gif
    image create photo Edit -format gif -file $cvscfg(bitmapdir)/edit.gif
    image create photo Delete -format gif -file $cvscfg(bitmapdir)/delete.gif
    image create photo Clear -format gif -file $cvscfg(bitmapdir)/clear.gif
    image create photo Refresh -format gif -file $cvscfg(bitmapdir)/refresh.gif
    image create photo Branches -format gif -file $cvscfg(bitmapdir)/logfile.gif
    image create photo Add -format gif -file $cvscfg(bitmapdir)/add.gif
    image create photo Remove -format gif -file $cvscfg(bitmapdir)/remove.gif
    image create photo Diff -format gif -file $cvscfg(bitmapdir)/diff.gif
    image create photo Checkin -format gif -file $cvscfg(bitmapdir)/checkin.gif
    image create photo Update -format gif -file $cvscfg(bitmapdir)/update.gif
    image create photo Modules -format gif -file $cvscfg(bitmapdir)/modules.gif
    image create photo Import -format gif -file $cvscfg(bitmapdir)/import.gif
    .bcheck        configure -image Check
    .bview_files   configure -image Notebook
    .bedit_files   configure -image Edit
    .bdelete_file  configure -image Delete
    .bclear        configure -image Clear
    .brefresh      configure -image Refresh
    .blogfile      configure -image Branches
    .badd_files    configure -image Add
    .bremove       configure -image Remove
    .bcheckin      configure -image Checkin
    .bupdate       configure -image Update
    .bdiff         configure -image Diff
    .bmodbrowse    configure -image Modules
    .bimport       configure -image Import
  }
  .bquit         configure -padx 4 -pady 0 -text "Quit"

  # Tooltips for the above buttons.

  if !{$TOOLTIPS_OFF} {
    set_tooltips .bedit_files \
      {"Edit the selected files using $cvscfg(editor) $cvscfg(editorargs)"}
    set_tooltips .bview_files \
      {{View the selected files}}
    set_tooltips .bdelete_file \
      {{Delete the selected files from the current directory}}
    set_tooltips .bclear \
      {{Unselect all files}}
    set_tooltips .brefresh \
      {{Re-read the current directory}}
    set_tooltips .blogfile \
      {{See the revision log and branches of the selected files}}
    set_tooltips .bcheck \
      {{Check the files in the current directory against the repository}}
    set_tooltips .badd_files \
      {{Add the selected files to the repository}}
    set_tooltips .bremove \
      {{Remove the selected files from the repository}}
    set_tooltips .bcheckin \
      {{Check the selected files in (commit) to the repository}}
    set_tooltips .bupdate \
      {{Update (a.k.a. patch, merge) the selected files from the repository}}
    set_tooltips .bdiff \
      {{See the differences between the selected files and the repository}}
    set_tooltips .bmodbrowse \
      {{Browse the modules in the repository or check out a module}}
    set_tooltips .bimport \
      {{Import the current directory into the repository}}
    set_tooltips .bquit \
      {{Exit from tkCVS}}
  }


  #
  # Pack the buttons.
  #
  if {$cvscfg(buttonstyle) == "Text"} {
    pack .dirfuncs -in .bottom1workspace -side top -padx 4
    pack .cvsfuncs -in .bottom1workspace -side top -padx 4
    pack .modfuncs -in .bottom1workspace -side top -padx 4
  } else {
    pack .dirfuncs -in .bottom1workspace -side left -padx 4
    pack .cvsfuncs -in .bottom1workspace -side left -padx 4
    pack .modfuncs -in .bottom1workspace -side left -padx 4
  }

  pack .lfilter .tfilter .lignore .tignore \
    -in .bottom1label -side left

    pack .bcheck .bview_files .bedit_files \
         .bdelete_file .bclear .brefresh \
      -ipadx 1 -ipady 1 -padx 1 -pady 1 \
      -in .dirfuncs -side left
    pack .blogfile .bdiff .badd_files \
         .bremove .bcheckin .bupdate \
      -ipadx 1 -ipady 1 -padx 1 -pady 1 \
      -in .cvsfuncs -side left
    pack .bmodbrowse .bimport \
      -ipadx 1 -ipady 1 -padx 1 -pady 1 \
      -in .modfuncs -side left

  #
  # Entry widget to be used for feedback
  #
  set feedback(cvs) [entry .feedback -width 55]
  pack .bquit -in .bottom2 -side right
  pack .feedback -in .bottom2 -side left -fill x -expand yes
    
  setup_dir
}

proc getFilename { id c } {
  global filenamePrefix

  set taglist [ getTagList $id $c ]
  set tagpos  [ lsearch $taglist $filenamePrefix* ]
  set tag     [ lindex $taglist $tagpos ]
  set filename [lindex [ split $tag $filenamePrefix ] 1 ]
  return $filename
}

proc getTagList { id c } {
  return [lindex [ $c itemconf $id -tags ] 4]
}

proc workdir_list_files {} {
  foreach item [.file_list curselection] {
    set itemstring [.file_list get $item]
    if {! [string match "no file *" $itemstring]} {
      if [info exists getlist] {
        lappend getlist $itemstring
      } else {
        set getlist [.file_list get $item]
      }
    }
  }

  if [info exists getlist] {
    return $getlist
  } else {
    return {.}
  }
}

proc workdir_view_file {args} {
  global cvscfg
  global cwd
  global feedback

  dbg_and_fix args

  if {$args == "."} {
    cvsfail "Please select some files to view first!"
    return
  }

  feedback_cvs $feedback(cvs) "Building scroll list, please wait!"
  if [file isdirectory $args] {
    change_dir $args
  } else {
    foreach file $args {
      catch {eval "exec cat $file 2>$cvscfg(null)"} view_this
      view_output "$file" $view_this
    }
  }
  feedback_cvs $feedback(cvs) ""
}

proc workdir_edit_file {args} {
  global cvscfg
  global cwd
  global feedback

  dbg_and_fix args
  if {$args == ""} {
    cvsfail "Please select some files to edit first!"
    return
  }

  feedback_cvs $feedback(cvs) "Building scroll list, please wait!"
  if [file isdirectory $args] {
    change_dir $args
  } else {
    set commandline "exec $cvscfg(editor)"
    foreach file $args {
      if {$cvscfg(editorargs) == {}} {
        eval exec $cvscfg(editor) $file >& $cvscfg(null) &
      } else {
        eval exec $cvscfg(editor) $cvscfg(editorargs) $args >& $cvscfg(null) &
      }
    }
  }
  feedback_cvs $feedback(cvs) ""
}

proc workdir_status_list_files {} {
  foreach item [.status_list curselection] {
    if [info exists getlist] {
      lappend getlist [.file_list get $item]
    } else {
      set getlist [.file_list get $item]
    }
  }

  if [info exists getlist] {
    set cur_select [.status_list curselection]
    set start_pos [ lindex $cur_select 0 ]
    set end_pos   [ expr [ llength $cur_select ] + $start_pos - 1 ]
    .file_list select set $start_pos $end_pos
    return $getlist
  } else {
    set cur_select [.status_list curselection]
    return {}
  }
}

proc workdir_status_list_file {yposition} {
  set cur_select [.status_list nearest $yposition]
  # .file_list select from $cur_select
  # .file_list select to   $cur_select
  return $cur_select
}

#------------------------------------------------------
# Update the "Go" menu for directories we can go to
# new_dir - the directory we're going to
# doPwd   - tells whether the directory path has
#           been specified  1 means relative to cwd
#                           0 means fully path specified
#-------------------------------------------------------
proc update_go {new_dir} {
  global .menubar.goto.m
  global dirlist
  global maxdirs
  global dirlen
  
  #puts "update_go: {$new_dir}"
  if {$new_dir == "." } { return }
  if {$new_dir == "~" } { return }
  if {$new_dir == ".."} {
    set new_dir [file dirname [pwd]]
  }
  if {[file pathtype $new_dir] == "relative"} {
    # Get full pathname of directory
    set new_dir [format {%s/%s} [pwd] $new_dir]
  }

  #puts $new_dir
  # Check if already in Go list
  set dirlocation  [lsearch -exact $dirlist $new_dir]

  # Move a directory already in the list to the top of the list
  if {$dirlocation != -1} {
    set dirlist [lreplace $dirlist $dirlocation $dirlocation ]
    set dirlist [linsert $dirlist 0 $new_dir]
  } else {
    set dirlist [linsert $dirlist 0 $new_dir]
  }
  set dirlen  [llength $dirlist]

  # Truncate end of directory list if we have too many directories
  if {$dirlen > $maxdirs} {
    set $dirlen [incr dirlen -1]
    set dirlist [lreplace $dirlist $dirlen $dirlen ]
  }
 
  # Destroy old menu selections for "Go"
  destroy .menubar.goto.m
  menu .menubar.goto.m
  .menubar.goto.m add command -label "Home" \
    -command {change_dir ~}

  # Rebuild menu selections for "Go" with new dirlist
  for {set i 0} {$i < $dirlen} {incr i 1} {
    set tmpdir [lindex $dirlist $i]
    .menubar.goto.m add command -label $tmpdir \
      -command [format {change_dir %s} $tmpdir]
  }
}

proc change_dir {new_dir} {
  global cwd

  #puts "change_dir {$new_dir}"
  update_go $cwd
  update_go $new_dir
  set cwd $new_dir
  setup_dir
}


# I modified this a lot to support the status listbox and marked canvas.
# I cringe at the size of the procedure -- it needs to be broken into smaller 
# ones badly.
# -sj

proc setup_dir {} {
  #
  # Call this when entering a directory.  It puts all of the file names
  # in the listbox, and reads the CVS or CVS.adm directory.
  #
  global cwd
  global module_dir
  global incvs
  global cvscfg
  global current_tagname

  .file_list delete 0 end
  .status_list delete 0 end
  .tag_list delete 0 end
  set module_dir "Not in the repository"
  set incvs 0
  set current_tagname "No directory tag"

  if [file isdirectory $cwd] {
    cd $cwd
    set cwd [pwd]

    cvsroot_check

    set cvscfg(ignore_file_filter) ""
    if { [ file exists ".cvsignore" ] } {
      set fileId [ open ".cvsignore" "r" ]
      while { [ eof $fileId ] == 0 } {
        gets $fileId line
        append cvscfg(ignore_file_filter) " $line"
      }
      close $fileId
    } else {
      if [info exists cvscfg(default_ignore_filter)] {
        set cvscfg(ignore_file_filter) $cvscfg(default_ignore_filter)
      }
    }

    set filelist [ getFiles ]

    # Select from those files only the ones we want (e.g., no CVS dirs)
    set j 0
    foreach i $filelist {
      if { [ isCmDirectory $i ] } {
        if {$i == "CVS"} {
          # New format CVS directory
          read_cvs_dir $cwd/$i
        } elseif {$i == "CVS.adm"} {
          # Old format CVS.adm directory
          read_cvs_adm_dir $cwd/$i
        } else {
          nop
        }
      } else {
        .file_list insert end $i
        # count actual number of visible elements (not showing CM directories)
        set j [ expr $j + 1 ]
      }
    }

    if {! $incvs} {
      set module_dir "Not a CVS directory."
      set current_tagname "Not a CVS directory."
      # unpack the status listbox and scrollbar from the screen
      pack forget .cright .scroll
      # repack the scrollbar into the file listbox
      pack .scroll -in .clbottom -side right -fill y -expand no -padx 2
    } elseif { $cvscfg(cvsver) > 1.2 } {
      # make sure the scroll bar is in the right frame
      pack forget .scroll 
      pack .cright -in .center   -side right -fill both -expand yes
      pack .scroll -in .crbottom -side right -fill y -expand no -padx 2 \
          -anchor w -before .status_list
      if { $cvscfg(auto_status) == "true" }  {
        #puts stdout "setup_dir: performing auto status."
        setup_columns
        # NOTE: this modifies .file_list, .status_list, and .tag_list!
      }
    }
  }
}


# Assumes .file_list has a list, and .status_list and .tag_list are empty
# and it will modify all three listboxes
proc setup_columns { } {
  global incvs
  global cvscfg
  global cvsver

  #puts stdout "setup_columns: entering function."
  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  #puts stdout ".file_list: [.file_list get 0 end]"
  #puts stdout ".status_list: [.status_list get 0 end]"
  #puts stdout ".tag_list: [.tag_list get 0 end]"

  if { $cvscfg(no_dot) } {
    set pt ""
  } else {
    set pt "."
  }

  # Note:  This is not backwards compatible with CVS 1.2.
  set awkCmd "\$0 ~ /Status:/ "
  append awkCmd "{ printf (\"\{%s \", \$0);} "
  append awkCmd "\$0 ~ /Sticky Tag:/ "
  append awkCmd "{ printf (\"%s\} \", \$0);}"

  set fileindex 0
  # fileindex cycles through .file_list

  # Set up a shell invocation to select certain status information
  set commandline "exec cvs -n -q  -l status -l $pt "

  if { $cvscfg(awkCmdOverFile) } {
    set pid [pid]
    set awkCmdFileName "$cvscfg(tmpdir)/awkCmd-$pid"
    set awkFile [open $awkCmdFileName w]
    puts $awkFile $awkCmd
    close $awkFile
    append commandline "| $cvscfg(awk) -f $awkCmdFileName"
  } else {
    append commandline "| $cvscfg(awk) {$awkCmd}"
    set awkCmdFileName ""
  }
  # gets cvs status in current directory only, pulling out lines that include
  # Status: or Sticky Tag:, putting each file's info (name, status, and tag)
  # into a list, which is an element in the overall list.
  # (Maybe could have used grep, since I'm taking the whole lines!)
  # (Note that {, }, ", and $ have to be \'ed so tclsh won't interpret them.)

  #puts stdout "setup_columns: commandline is: \"$commandline\""
  catch { eval $commandline } str
  set strlen [ expr [ llength $str ] ]
  #puts stdout "caught this, with $strlen elements: \"$str\""

  if { $awkCmdFileName != "" } {
    eval exec $cvscfg(rm_cmd) $cvscfg(rm_flags) $awkCmdFileName
  }

  set strindex 0

  while { $strindex < $strlen } {
    set elem [ lindex $str $strindex ]
    #puts stdout "element #$strindex: $elem"

    # The the word "File:" is first
    set filenameindex 0

    # Find the word "Status:"
    set statusindex [ expr [ lsearch -regexp $elem {Status:} ] ]
    #puts stdout "statusindex $statusindex"

    # Find the expression "Sticky Tag:" and mark the word "Tag:"
    set stickytagindex [ expr [ lsearch -regexp $elem {Tag:} ] ]
    #puts stdout "stickytagindex $stickytagindex"

    # First get the file name, or "no file xyz"
    set fileexpr [
        lrange $elem [ expr $filenameindex +1 ] [ expr $statusindex -1 ] ]
    if { [ expr [ llength $fileexpr ] == 1 ] } {
        set filename $fileexpr
    } else {
        set filename [ lindex $fileexpr end ]
    }

    # Get the status
    set status [
        lrange $elem [ expr $statusindex +1 ] [ expr $stickytagindex -2 ] ]

    # Get the sticky tag
    set stickytag [
        lrange $elem [ expr $stickytagindex +1 ] [ expr [ llength $elem ] -1 ] ]
    if { $stickytag == "(none)" } {
        set stickytag "(main)"
    }
    # We've found the file name, status, and tag from CVS for this element
    #puts stdout "file \"$filename\" status \"$status\" tag \"$stickytag\""

    # Now try to attach all that to one of the "given" files
    set givenfilename [ .file_list get $fileindex ]
    #puts stdout "looking for directory file \"$givenfilename\""
    while { $givenfilename < $filename && $fileindex < [.file_list size] } {
        # Both lists were alphabetical, so we have one in .file_list that
        # cvs didn't find
        #puts stdout "\"$givenfilename\" not in repository"
        if [ file isdirectory $givenfilename ] {
            .status_list insert end "<directory>"
            .tag_list insert end " "
        } else {
            .status_list insert end "  ?"
            .tag_list insert end " "
        }
        set fileindex [ expr $fileindex +1 ]
        set givenfilename [ .file_list get $fileindex ]
        #puts stdout "looking for directory file \"$givenfilename\""
    }
    if { $fileindex < [.file_list size] } {
        if { $givenfilename == $filename } {
            #puts stdout "found file $filename"
            .status_list insert end $status
            .tag_list insert end $stickytag
        } else {
            # Both lists were alphabetical, so now ($givenfilename > $filename)
            # we have one that wasn't in .file_list but cvs found it
            #puts stdout "\"$filename\" in cvs but not in current directory"
            .file_list insert $fileindex $fileexpr
            .status_list insert end $status
            .tag_list insert end $stickytag
        }

        set fileindex [ expr $fileindex +1 ]

    } else {
        # We're past the end of the files that were given
        .file_list insert end $fileexpr
        .status_list insert end $status
        .tag_list insert end $stickytag
        set fileindex [ expr $fileindex +1 ]
    }

    set strindex [ expr $strindex +1 ]
  }

  # Now process any more local files not in repository
  while { $fileindex < [.file_list size] } {
      # Almost same steps as above "while $givenfilename < $filename" section
      set givenfilename [ .file_list get $fileindex ]
      #puts stdout "\"$givenfilename\" not in repository"
      if [ file isdirectory $givenfilename ] {
            .status_list insert end "<directory>"
            .tag_list insert end " "
      } else {
          .status_list insert end "  ?"
          .tag_list insert end " "
      }
      set fileindex [ expr $fileindex +1 ]
  }


  #puts stdout "setup_columns: exiting function."
}


proc read_cvs_adm_dir {dirname} {
#
# Reads an old format CVS.adm directory
#
  global module_dir
  global incvs

  if [file isdirectory $dirname] {
    if [file isfile $dirname/Repository] {
      set module_dir [exec cat $dirname/Repository]
      set incvs 1
    } else {
      cvsfail "Repository file not found in $dirname"
    }
  } else {
    cvsfail "$dirname is not a directory"
  }
}

proc read_cvs_dir {dirname} {
#
# Reads a new format CVS directory
#
  global module_dir
  global incvs
  global cvscfg
  global current_tagname

  if [file isdirectory $dirname] {
    if [file isfile $dirname/Repository] {
      set module_dir [exec cat $dirname/Repository]
      if [file isfile $dirname/Root] {
        set cvscfg(cvsroot) [exec cat $dirname/Root]
        set cvscfg(cvsver) 1.4
      }
      if [file isfile $dirname/Tag] {
        set current_tagname [string trimleft [exec cat $dirname/Tag] "T"]
      }
      set incvs 1
    } else {
      cvsfail "Repository file not found in $dirname"
    }
  } else {
    cvsfail "$dirname is not a directory"
  }
}

proc workdir_scroll {args} {
# To support scrolling 3 listboxes simultaneously

  #puts "args = $args"
  eval ".file_list     yview $args"
  eval ".status_list   yview $args"
  eval ".tag_list      yview $args"
}

proc workdir_cleanup {} {
  global cvscfg

  set commandline "$cvscfg(rm_cmd) $cvscfg(clean_these)"
  if { [ are_you_sure "You are about to execute this delete command:\n$commandline" {} ] == 1 } {
    set list [ split $cvscfg(clean_these) " " ]
    set results ""
    foreach item $list {
      if { $item != "" } {
        #puts stdout "cleaning up matches for pattern \"$item\""
        catch { eval exec $cvscfg(rm_cmd) $cvscfg(rm_flags) [ glob $item ] } view_this
        if { $view_this != "" } {
          set results "$results\n$view_this"
        }
      } else {
        nop
      }
    }
    view_output "Clean" $results
    setup_dir
  }
}

proc workdir_delete_file {args} {
  global cvscfg

  dbg_and_fix args

  if {$args == "."} {
    cvsfail "Please select some files to delete first!"
    return
  }

  if { [ are_you_sure \
          "This will delete these files from your local, working directory:" \
          $args ] == 1 } {
    foreach file $args {
      eval "exec $cvscfg(rm_cmd) $cvscfg(rm_flags) $file "
    }
    setup_dir
  }
}

proc are_you_sure {mess args} {
#
# General posting message
#
  global cvscfg

  dbg_and_fix args
   
  if { $cvscfg(confirm_prompt) != "false" } {
    append mess "\n"
    set indent "      "

    foreach item $args {
      if { $item != {} } {
        append mess " $indent"
        set val [ lindex $item 0 ]
        append mess " $val\n"
      }
    }
    append mess "\nAre you sure?"
    if {[cvsconfirm $mess] == 1} {
      cvsok "Aborted at user request."
      return 0
    }
  }
  return 1
}

# 
# Sets all cursors to busy, executes command, and restores cursors.
# 
# I believe I got this from GIC. Only some of the functions use it;
# was not immediately clear to me how to get all functions to use it, 
# however.
# -sj
#
proc busy {cmds} {
  #global errorInfo

  set busy {.app}
  set list [winfo children .]
  while {$list != ""} {
    set next {}
    foreach w $list {
      set cursor [lindex [$w config -cursor] 4]
      if {[winfo toplevel $w] == $w || $cursor != ""} {
        lappend busy [list $w $cursor]
      } else {
        lappend busy [list $w {}]
      }
      set next [concat $next [winfo children $w]]
    }
    set list $next
  }

  foreach w $busy {
    catch {[lindex $w 0] config -cursor watch}
  }

  update idletasks

  set error [catch {uplevel eval $cmds} result]
  #set ei $errorInfo

  foreach w $busy {
    catch {[lindex $w 0] config -cursor [lindex $w 1]}
  }

  if $error {
    #error $result $ei
  } else {
    return $result
  }
}

proc workdir_print_file {args} {
  global cvscfg

  dbg_and_fix args

  if {$args == "."} {
    cvsfail "Please select some files to print first!"
    return
  }

  set mess "This will print these files:\n\n"
  foreach file $args {
    append mess "   $file\n"
  }
  append mess "\nUsing $cvscfg(print_cmd)\n"
  append mess "\nAre you sure?"
  if {[cvsconfirm $mess] == 0} {
    set final_result ""
    foreach file $args {
      catch { eval exec $cvscfg(print_cmd) $file } file_result
      if { $file_result != "" } {
        set final_result "$final_result\n$file_result"
      }
    }
    if { $final_result != "" } {
      view_output "Print" $final_result
    }
    if { $cvscfg(auto_status) == "true"} {
      setup_dir
    }
  }
}

proc workdir_format_file {args} {
  global cvscfg

  dbg_and_fix args

  if {$args == "."} {
    cvsfail "Please select some files to print first!"
    return
  }

  if { [are_you_sure "This will format these files:" $args] == 1} {
    foreach file $args {
      exec $cvscfg(format_cmd) $file
    }
    setup_dir
  }
}


proc cvsroot_check {} {
  global cvscfg
  global incvs
  global env

  if { $incvs } {
    if [file isfile "./CVS/Root"] {
      set f [ open "./CVS/Root" r ]
      gets $f root
      close $f
      if {! [file isdirectory $root]} {
        puts "$root: No such repository"
      } else {
        set cvscfg(cvsroot) $root
      }
    }
  }
}

proc nop {} {}

proc disabled {} {
  cvsok "Command disabled."
}

proc isCmDirectory { file } {
  switch $file  {
    "CVS"  - 
    "CVS.adm"  - 
    "RCS"  - 
    "SCCS" { set value 1 } 
    default { set value 0 } 
  }
  return $value
}

# Get the files in the current working directory.  Use the file_filter
# values Add hidden files if desired by the user.  Sort them to match
# the ordering that will be returned by cvs commands (this matches the
# default ls ordering.).
proc getFiles {} {
  global cvscfg

  set filelist ""
    
  # make sure the file filter is at least set to "*".
  if { $cvscfg(file_filter) == "" } {
    set cvscfg(file_filter) "*"
  }

  # get the initial file list, including hidden if requested
  if {$cvscfg(allfiles)} {
    # get hidden as well
    foreach item $cvscfg(file_filter) {
      catch { set filelist [ concat [ glob .$item $item ] $filelist ] }
    }
  } else {
    foreach item $cvscfg(file_filter) {
      catch { set filelist [ concat [ glob $item ] $filelist ] }
    }
  }
  # ignore files if requested
  if { $cvscfg(ignore_file_filter) != "" } {
    foreach item $cvscfg(ignore_file_filter) {
      # for each pattern
      if { $item != "*" } {
        # if not "*"
        while { [set idx [lsearch $filelist $item]] != -1 } {
          # for each occurence, delete
          catch { set filelist [ lreplace $filelist $idx $idx ] }
        }
      }
    }
  }

  # make sure "." is always in the list for 'cd' purposes
  if { ( [ lsearch -exact $filelist "." ] == -1 ) } {
    set filelist [ concat "." $filelist ]
  }
    
  # make sure ".." is always in the list for 'cd' purposes
  if { ( [ lsearch -exact $filelist ".." ] == -1 ) } {
    set filelist [ concat ".." $filelist ]
  }
    
  # sort it
  set filelist [ lsort $filelist ]
    
  # if this directory is under CVS and CVS is not in the list, add it. Its
  # presence is needed for later processing
  if { ( [ file exists "CVS" ] ) && 
       ( [ lsearch -exact $filelist "CVS" ] == -1 ) } {
    #puts "********* added CVS"
    catch { set filelist [ concat "CVS" $filelist ] }
  }
  #puts stdout "-------------\nfilelist=$filelist\n------------\n"
  return $filelist
}

proc feedback_cvs { e message } {
#
# This code is adapted from the text "Practical Programming in
# Tcl and Tk", by Brent B. Welch (see page 209)
# An entry widget is used because it won't change size
# base on the message length, and it can be scrolled by
# dragging with button 2.
# Author: Eugene Lee, Aerospace Corporation, 9/6/95
#
  global feedback
  global cvscfg

  $e config -state normal
  $e delete 0 end
  $e insert 0 $message
  # Leave the entry in a read-only state
  $e config -state disabled

  # Force a disable update
  update idletasks
}

proc exit_cleanup { } {
  global cvscfg
  
  set pid [pid]
  catch {eval exec rm -r $cvscfg(tmpdir)/cvstmpdir.$pid}
  destroy .
  exit
}
