/* TOM default configuration
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: default.h,v 1.82 1999/05/11 09:43:30 tiggr Exp $  */

/* This configuration file defines default values of all configuration
   settings needed by TOM.  For any machine you'll need to include this
   file and override the values which need to have different values.  */
#include <config/config.h>

/* Define this to 0 when this target does not employ os/os.c.  */
#ifndef HAVE_OS_OS_C
#define HAVE_OS_OS_C  1
#endif

/* The stack traversal policy used by the runtime; this affects code
   output by the compiler.  If the value is SP_PROTECT, all stack objects
   are considered root objects, and they are ensured to be gray during the
   protection phase.  It also implies that, in the context of incremental
   garbage collection, every assignment to a local reference var must
   ensure that the object is grayed.  With SP_MARK protection, the stack
   is marked, turning white objects gray, every time the number of gray
   objects reaches zero during the marking pahse of the garbage collector.
   This implies that, irrespective of the garbage collection policy, the
   check that an object being assigned to a stack variable is gray, can be
   omitted.  */
#ifndef STACK_PROTECT
#define STACK_PROTECT	SP_MARK
#endif
#define SP_PROTECT	0
#define SP_MARK		1

/* Iff !0, stack protection structs are needed to walk the stack.  Iff 0,
   object chunks are allocated from large ranges of memory, to be able to
   test for something found on the stack being a pointer to an object.
   These ranges are allocated from the OS by mmap, vm_alloc or similar
   calls.  */
#ifndef STACK_REF_STRUCT
#define STACK_REF_STRUCT  0
#endif

/* Iff !0, a pointer to each extension struct is cached in a variable
   which is local to the method referencing object variables from that
   extension.  This causes better code to be generated for methods
   referencing more than once a variable from said extension struct.  */
#ifndef CACHE_EXTENSION_POINTER
#define CACHE_EXTENSION_POINTER  1
#endif

/* The default load path.  */
#ifndef DEFAULT_LOAD_PATH
#define DEFAULT_LOAD_PATH	1, PATH_PREFIX @"/share/tom"
#endif

/* Iff !0, malloc is thread safe (or we can't be multi-threaded, which is
   the same).  The default is 1, i.e. YES, we're thread safe.  */
#ifndef MALLOC_THREAD_SAFE
#define MALLOC_THREAD_SAFE  1
#endif

/* Iff !0, mmap, when used, does not grok MAP_FIXED very well.  */
#ifndef MMAP_NOT_FIXED
#define MMAP_NOT_FIXED  0
#endif

/* Iff !0, use  valloc for allocating chunk ranges.  */
#ifndef CHUNK_RANGE_VALLOC
#define CHUNK_RANGE_VALLOC  0
#endif

/* Macros to fetch from a va_list AP the next entity with the indicated
   type.  Currently only (needed) for smaller-than-int types.  */
#ifndef VA_ARG_BYTE
#define VA_ARG_BYTE(AP)  (va_arg ((AP), tom_byte))
#endif
#ifndef VA_ARG_CHAR
#define VA_ARG_CHAR(AP)  (va_arg ((AP), tom_char))
#endif
#ifndef VA_ARG_FLOAT
#define VA_ARG_FLOAT(AP)  (va_arg ((AP), tom_float))
#endif

/* The type passed to __builtin_return.  */
#ifndef BUILTIN_RETURN_TYPE
#define BUILTIN_RETURN_TYPE  \
union				\
{				\
  struct { tom_int i; } i;	\
  struct { tom_long l; } l;	\
  struct { void *p; } p;	\
  struct { tom_double d; } d;	\
  struct { tom_float f; } f;	\
}
#endif

/* Macros to retrieve the difficult types out of a builtin_return_type
   thing.  Currently only needed for float and double.  */
#ifndef RETURN_RETRIEVE_DOUBLE
#define RETURN_RETRIEVE_DOUBLE(RESULT)  ((RESULT)->d.d)
#endif
#ifndef RETURN_RETRIEVE_FLOAT
#define RETURN_RETRIEVE_FLOAT(RESULT)  ((RESULT)->f.f)
#endif
#ifndef RETURN_SET_DOUBLE
#define RETURN_SET_DOUBLE(RESULT, VALUE)  ((RESULT)->d.d = (VALUE))
#endif
#ifndef RETURN_SET_FLOAT
#define RETURN_SET_FLOAT(RESULT, VALUE)  ((RESULT)->f.f = (VALUE))
#endif

/* Parts of constructing an invocation.

   Perform any wrapping up of the ARGS needed to perform the actual
   application.  */
#ifndef APPLY_ARGS_COMPLETE
#define APPLY_ARGS_COMPLETE()  \
      do ; while (0)
#endif

#ifndef APPLY_ARGS_CONTINUE
#define APPLY_ARGS_CONTINUE()  \
      do ; while (0)
#endif

/* APPLY_ARGS_ARGS, APPLY_ARGS_APPLY and APPLY_ARGS_RETURN correspond to
   gcc's __builtin_apply_args, __builtin_apply, and __builtin_return.  The
   extra RET argument passed to APPLY_ARGS_APPLY should be a pointer to a
   builtin_return_value to be (possibly) used to store the result of the
   apply.

   If builtin_return_value values are forged by something other than
   APPLY_ARGS_APPLY, they should be BZERO'ed first.  Otherwise things will
   fail in mysterious ways on the i386.  */
#ifndef APPLY_ARGS_ARGS
#define APPLY_ARGS_ARGS  \
  __builtin_apply_args
#endif

#ifndef APPLY_ARGS_APPLY
#define APPLY_ARGS_APPLY(FUNC, ARGS, SIZE, RET)	 \
  __builtin_apply ((FUNC), (ARGS), (SIZE))
#endif

#ifndef APPLY_ARGS_RETURN
#define APPLY_ARGS_RETURN(RESULT)  \
  __builtin_return (RESULT)
#endif

/* Emit code to fill with zeros the NUM ELTs,
   where ELT is not a pointer.  */
#ifndef EFILLZERO
#define EFILLZERO(ELT, NUM)  \
  formac (of, @"bzero (&(%@), %d * sizeof (%@));\n", (ELT), (NUM), (ELT))
#endif

/* Output garbage for every generated C file to the stream F.  */
#ifndef OUTPUT_FILE_PREAMBLE
#define OUTPUT_FILE_PREAMBLE(F)  do ; while (0)
#endif

/* Call bzero, or whatever is faster.  Default calls bzero.  */
#ifndef BZERO
#define BZERO(A, N)  bzero ((A), (N))
#endif

/* Now how do we stringify the actual value of the macro passed as X?  */
#define GETSTR(Y)	#Y

/* Extensions of various files, sans dot.  */
#define TOM_IMPLEMENTATION_SUFFIX	@"t"
#define TOM_INFORMATION_SUFFIX		@"i"
#define TOM_INTERFACE_SUFFIX		@"j"
#define TOM_UNIT_SUFFIX			@"u"
#define TOM_RESOLVER_UNIT_SUFFIX	@"-r"

/* Version of the file information file written by the compiler and read
   by the resolver (liblti, actually).  */
#define TOM_INFO_FILE_VERSION  1

/* The name of the various classes and units.  */
#define TOM_CLASS_NAME_ANY		@"Top"
#define TOM_CLASS_NAME_ALL		@"Any"
#define TOM_CLASS_NAME_COMMON		@"All"
#define TOM_CLASS_NAME_CONDITION	@"Condition"
#define TOM_CLASS_NAME_CONDITION_CLASS	@"ConditionClass"
#define TOM_CLASS_NAME_STATE		@"State"
#define TOM_CLASS_NAME_STRING		@"ByteString"
#define TOM_UNIT_NAME_TOM		@"tom"
#define TOM_UNIT_NAME_BUILTIN		@"_builtin_"
#define TOM_UNIT_NAME_MISSING		@"_missing_"
#define TOM_FILE_NAME_BUILTIN		@"_builtin_"
#define TOM_FILE_NAME_MISSING		@"_missing_"

/* Subclasses of these classes are treated specially by the garbage
   collector, as indicated by their initial ASI value.  */
#define TOM_CLASS_NAME_ARRAY		@"Array"
#define TOM_CLASS_NAME_OBJECT_ARRAY	@"ObjectArray"

/* Various prefixes in the output.  */
#define TO_SELECTOR_PREFIX	@"_sd_"
#define TO_META_DEF_PREFIX	@"_md_"
#define TO_META_MED_PREFIX	@"_med_"
#define TO_META_REF_PREFIX	@"_mr_"
#define TO_SUPER_REF_PREFIX	@"_sr_"
#define TO_METACLASS_DEF_PREFIX	@"_mc_"
#define TO_META_REF_PREFIX	@"_mr_"
#define TO_MDT_PREFIX		@"_mdt_"
#define TO_EOT_PREFIX		@"_eot_"
#define TO_EXT_ID_PREFIX	@"_ei_"
#define TO_EXT_DESC_PREFIX	@"_ed_"
#define TO_EXT_STRUCT_PREFIX	@"_es_"
#define TO_EXT_POINTER_PREFIX	@"_ep_"
#define TO_UNIT_DEF_PREFIX	@"_ud_"

/* The prefix of the name of the Reference Variable Offset information.  */
#define TO_META_RVO_PREFIX	@"_rvo_"

/* The prefix of string constant object references.  */
#define TO_STRING_CST_PREFIX	@"_cst_"

/* The prefix of string constant object definitions.  */
#define TO_STRING_DST_PREFIX	@"_dst_"

/* The name of the global pointer to the head of the stack protection
   list.  */
#define TO_TRT_PROTECT_STACK	@"_trt_sp"

/* The name of the local stack protection struct holding the referencing
   local variables.  */
#define TO_PROTECT_STACK	@"_sp"

/* The name of the array pointing to the referencing arguments.  */
#define TO_PROTECT_STACK_ARGS	@"_sp_args"

/* The prefix of the name of the definition of a Argument Types
   Definition.  */
#define TO_ATD_PREFIX		@"_atd_"

/* The names of various functions.  */
#define TO_TRT_ASSIGN_LOCAL	@"trt_assign_local"
#define TO_TRT_ASSIGN_OBJECT_VAR @"trt_assign_object_var"

/* Various names.  */
#define TO_NAME_CMD		@"cmd"
#define TO_NAME_SELF		@"self"
#define TO_NAME_ISA		@"isa"
#define TO_NAME_ASI		@"asi"
#define TO_NAME_EOT		@"eot"
#define TO_NAME_EOT_OFFSET	@"offset"
#define TO_SEL_MAIN		@"i_main_r"

/* The name of the module information of a dynamically loaded object.  */
#define TRT_MODULE_INFO		"trt_module_info"

/* The type of extension identities.  */
#define TO_EXT_ID_TYPE		@"unsigned int"

/* The (internal) names of methods to use when read indexing.  */
#define MNP_AT_1		unique_identifier (@"at")

/* The name parts of the method to use when write indexing.  */
#define MNP_SET_AT_1		unique_identifier (@"set")
#define MNP_SET_AT_2		unique_identifier (@"at")

/* Macro, sans semicolon, implementing actions for the target to patch
   user supplied flags.  */
#ifndef TARGET_PATCH_FLAGS
#define TARGET_PATCH_FLAGS  \
  do					\
    {					\
    } while (0)
#endif

/* The information contained in every meta, apart from the ISA and ASI.  */
#define TRO_META_COMMON_INFORMATION  @"struct trt_class_info info;"

/* (trt/alloc.c) !0 iff chunk ranges are (used and) aligned at their size.  */
#ifndef RANGES_ARE_ALIGNED
#define RANGES_ARE_ALIGNED  HAVE_VM_ALLOCATE
#endif

/* (trt/alloc.c) Return !0 iff the ADDRESS is contained in the RANGE.  */
#ifndef ADDRESS_IN_RANGE
#if RANGES_ARE_ALIGNED
#define ADDRESS_IN_RANGE(ADDR, RANGE)  \
  (((POINTER_INT_TYPE) (ADDR) & (RANGE)->mask)	\
   == (POINTER_INT_TYPE) (RANGE)->first)
#else
#define ADDRESS_IN_RANGE(ADDR, RANGE)  \
  ((ADDR) > (char *) (RANGE)->first					\
   && (ADDR) < ((char *) (RANGE)->first + (RANGE)->num * vm_page_size))
#endif
#endif

/* (trt/alloc.c) The size of chunk ranges, in bytes.  If
   RANGES_ARE_ALIGNED, this should be a power of 2.  */
#ifndef RANGE_SIZE
#define RANGE_SIZE  (2 * 1024 * 1024)
#endif

/* (trt/alloc.c) The first address at which to try to place a chunk range.
   If this is large, and a power-of-two multiple of RANGE_SIZE, chunk
   ranges can actually grow without the need for extra chunks.  This is
   only important if RANGES_ARE_ALIGNED.  */
#ifndef FIRST_RANGE_ADDRESS
#define FIRST_RANGE_ADDRESS  0
#endif

/********** dynamic loading **********/

/* Initialize dynamic loading.  */
void dload_initialize ();

/* Load from the file NAME, returning its handle.  */
void *dload_load (char *name);

/* Lookup the symbol named NAME from the object with the HANDLE.  */
void *dload_lookup (void *handle, char *name);

#ifndef DLOAD_SYMBOL_PREFIX
#define DLOAD_SYMBOL_PREFIX ""
#endif

/********** debuggin **********/

#ifndef DEBUG_MESSAGE_MONITORING
#define DEBUG_MESSAGE_MONITORING  1
#endif

#ifndef NO_MALLOC_STATS
#define NO_MALLOC_STATS  1
#endif
