/* Generic i386.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: i386.h,v 1.13 1999/01/05 11:55:29 tiggr Exp $  */

#define BUILTIN_RETURN_TYPE  \
union							\
{							\
  struct { tom_int i; } i;				\
  struct { tom_long l; } l;				\
  struct { void *p; } p;				\
  struct 						\
  {							\
    char d[10];						\
    char float_used; 					\
  } d;							\
}

#define RETURN_RETRIEVE_DOUBLE(RESULT)  \
  ({								\
    double d;							\
								\
    __asm__ volatile ("fldt (%0)" : : "r" ((RESULT)->d.d));	\
    __asm__ volatile ("fstpl (%0)" : : "r" (&d));		\
    d;								\
  })

#define RETURN_RETRIEVE_FLOAT(RESULT)  RETURN_RETRIEVE_DOUBLE (RESULT)

#define RETURN_SET_DOUBLE(RESULT, VALUE)  \
  do								\
    {								\
      double d = (VALUE);					\
      __asm__ volatile ("fldl (%0)" : : "r" (&d));		\
      __asm__ volatile ("fstpt (%0)" : : "r" ((RESULT)->d.d));	\
      (RESULT)->d.float_used = 1;				\
    } while (0)

#define RETURN_SET_FLOAT(RESULT, VALUE)  RETURN_SET_DOUBLE (RESULT, VALUE)

/* Too coarse, but works on all machines.  */
#define REG_PROT_START	0
#define REG_PROT_END	(sizeof (jmp_buf) / sizeof (void *))

/* The macros for building the arguments to __builtin_apply (i.e. most
   of the rest of this file) depend on the fact that _all_ arguments
   are passed on the stack.  In fact, this code equals the m68k-next
   code where the same applies.  */

/* Macro local to this target file to emit a value of some type to the
   ARGS being built.  */
#define APPLY_ARGS_EMIT_VALUE(TYPE, VALUE)  \
({								\
    TYPE *addr = (void *) ((char *) args->stack + offset);	\
    *addr = (VALUE);						\
    offset += sizeof (TYPE);					\
    addr;})

/* The size of the registers in the ARGS to __builtin_apply.
   XXX This is 0, as all arguments are passed on the stack.  */
#define APPLY_ARGS_REG_SIZE  0

/* Start building the ARGS to __builtin_apply.
   This should be called init_cumulative_args :-) */
#define APPLY_ARGS_START(SEL)  \
  do			\
    {			\
      int offset = 0

/* Return an estimate, which is guaranteed to be large enough, for the
   size of the stack arguments to __builtin_apply_args.

   Worst case is the implicit first arguments SELF and CMD, followed
   by all double arguments, followed by the tuple return value
   pointers.  */
#define APPLY_ARGS_STACK_SIZE(SEL)  \
  (2 * sizeof (void *) + sizeof (tom_double) * (SEL)->in->num	\
   + sizeof (void *) * (SEL)->out->num)

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_long, VALUE)

/* Add a float value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_float, VALUE)

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_double, VALUE)

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (void *, VALUE)

/* Return the actual size of the stack arguments to __builtin_apply_args.  */
#define APPLY_ARGS_ACTUAL_SIZE()  \
      offset

/* Undo anything started by APPLY_ARGS_START.  */
#define APPLY_ARGS_END()  \
    } while (0)

/*
 *  The following section is needed because gcc's __builtin_apply and
 *  __builtin_return are broken on the i386
 */

/*  We need access to the FPU environement structure stored
    with fstenv and loaded with fldenv.  */
#define I386_FPU_ENVIRONMENT \
struct {			\
    tom_char control;  		\
    tom_char control_reserved;	\
    tom_char status;		\
    tom_char status_reserved;	\
    tom_char tag;		\
    tom_char tag_reserved;	\
    char reserved[16];		\
};

#define I386_EMPTY_MASK		0x4100

#define APPLY_ARGS_APPLY(FUNC, ARGS, SIZE, RET) \
  ({								\
    BUILTIN_RETURN_TYPE *builtin_return = (void *)(RET);	\
    volatile struct						\
      {								\
        void *func;						\
	void *args;						\
	int size;						\
	BUILTIN_RETURN_TYPE *builtin_return;			\
        int stack_top_status;					\
        int save_sp;						\
      } info;							\
    info.func = (void *)(FUNC);					\
    info.args = *(void **)(ARGS);					\
    info.size = (int)(SIZE);					\
    info.builtin_return = (void *)builtin_return;		\
								\
    __asm__ ("subl 8(%0), %%esp\n\t"				\
	     "movl %%esp, 20(%0)\n\t"				\
	     "pushl 8(%0)\n\t"					\
	     "pushl 4(%0)\n\t"					\
	     "pushl 20(%0)\n\t"					\
	     "call memcpy\n\t"					\
	     "addl $12, %%esp\n\t"				\
	     "ffree %%st\n\t"					\
	     "call *(%0)\n\t"					\
	     "addl 8(%0), %%esp\n\t"				\
       	     "movl 12(%0), %%ecx\n\t"				\
	     "movl %%eax, 0(%%ecx)\n\t"				\
	     "movl %%edx, 4(%%ecx)\n\t"				\
	     "fxam\n\t"						\
	     "fstsw 16(%0)\n\t"					\
	     : : "r" (&info)					\
	     : "eax", "ecx", "edx", "st");			\
								\
    if((info.stack_top_status & I386_EMPTY_MASK) 		\
       != I386_EMPTY_MASK)					\
      {								\
        builtin_return->d.float_used = 1;			\
	__asm__ ("fstpt %0\n\t"					\
		 : "=m" (*builtin_return) : : "st");		\
      }								\
    else							\
      {								\
        builtin_return->d.float_used = 0;			\
      }								\
								\
    (void *)builtin_return;						\
  })

#define APPLY_ARGS_RETURN(RESULT) \
  ({								\
    BUILTIN_RETURN_TYPE *builtin_return = (void *)(RESULT);	\
								\
    if (builtin_return->d.float_used)				\
      {								\
        __asm__ ("fldt (%0)\n\t"			   	\
	         : : "r" (builtin_return) : "st");		\
      } 							\
    else 							\
      {								\
        __asm__ ("mov 0(%0), %%eax\n\t"				\
	         "mov 4(%0), %%edx\n\t"				\
	         : : "r" (builtin_return) 			\
	         : "eax", "edx");				\
      }								\
    return;							\
  })

