/* Generic ppc.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1997 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: ppc.h,v 1.4 1999/05/03 15:47:00 tiggr Exp $  */

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; tom_double d; } d;	\
  struct { tom_int a, b; tom_double f; } f;	\
}

#define VA_ARG_BYTE(AP)  (va_arg ((AP), tom_int))
#define VA_ARG_CHAR(AP)  (va_arg ((AP), tom_int))

#define TGC_MARK_REGISTERS()  \
  do									\
    {									\
      jmp_buf regs;							\
      int r;								\
									\
      setjmp (regs);							\
									\
      for (r = 0; r < sizeof (regs[0].__jmpbuf) / regs[0].__jmpbuf[0]; r++) \
	if ((char *) regs[0].__jmpbuf[r] >= lowest_range_addr)		\
	  check_for_reference ((char *) regs[0].__jmpbuf[r]);		\
    } while (0)


/* XXX I assume the floating point regs never hold addresses...
   Fri Aug  1 16:02:06 1997, tiggr@dev.linuxppc.org  */
#define REG_PROT_START	((char **) &(((jmp_buf) 0)->__jmpbuf.__misc[0]) \
			 - (char **) ((jmp_buf) 0))
#define REG_PROT_END	((char **) &(((jmp_buf) 0)->__jmpbuf.__fpregs[0]) \
			 - (char **) ((jmp_buf) 0))

#define APPLY_ARGS_REG_SIZE  (8 * sizeof (int) + 8 * sizeof (double))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int ireg_offset = 0, fpreg_offset = 0, stack_offset = 0;		\
      int reserved_size = (sizeof (void *) * (SEL)->out->num		\
			   + sizeof (tom_double) * (SEL)->in->num)

#define APPLY_ARGS_STACK_SIZE(SEL)  \
      reserved_size

/* Macro local to this target file to emit a value of some non-floating type
   to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
({							\
    TYPE *addr;						\
							\
    if (ireg_offset < 32)				\
      {							\
	addr = (void *) &args->reg[4 + ireg_offset];	\
	ireg_offset += 4;				\
      }							\
    else						\
      {							\
	/* XXX Haven't thought about this yet...  */	\
	abort ();					\
      }							\
							\
    *addr = (VALUE);					\
    addr;})

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
({									\
    tom_long *addr;							\
									\
    if (ireg_offset < 32)						\
      ireg_offset = (ireg_offset + 7) & ~7;				\
									\
    if (ireg_offset < 32)						\
      {									\
	addr = (void *) &args->reg[4 + ireg_offset];			\
	ireg_offset += 8;						\
      }									\
    else								\
      {									\
	/* XXX Haven't thought about this yet...  */			\
	abort ();							\
      }									\
									\
    *addr = (VALUE);							\
    addr;})

/* Add a float value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
({							\
    void *addr;						\
							\
    if (fpreg_offset < 64)				\
      {							\
	addr = (void *) &args->reg[40 + fpreg_offset];	\
	*(tom_double *) addr = (VALUE);			\
	fpreg_offset += 8;				\
      }							\
    else						\
      {							\
	/* XXX Haven't thought about this yet...  */	\
	abort ();					\
      }							\
							\
    addr;})

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
({							\
    void *addr;						\
							\
    if (fpreg_offset < 64)				\
      {							\
	addr = (void *) &args->reg[40 + fpreg_offset];	\
	*(tom_double *) addr = (VALUE);			\
	fpreg_offset += 8;				\
      }							\
    else						\
      {							\
	/* XXX Haven't thought about this yet...  */	\
	abort ();					\
      }							\
							\
    addr;})

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_COMPLETE()  \
      do						\
	{						\
	  if (stack_offset == 0)			\
	    args->stack = 0;				\
	  else						\
	    {						\
	      abort ();					\
	    }						\
	} while (0)

#define APPLY_ARGS_ACTUAL_SIZE()  \
      (stack_offset)

#define APPLY_ARGS_END()  \
    } while (0)
