<copyright> The 24-game, in the Netherlands well known from the Flippo's.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: 24-game.t,v 1.35 1999/07/15 21:54:19 tiggr Exp $</id>
    </copyright>

<doc> The original implementation in C(++) was done by Raymond Nijssen
    <raymond@ics.ele.tue.nl>.

    This implementation provides slightly different (and more elegant!)
    functionality.  </doc>
implementation class
Game: instance (All)
{
  <doc> Some paramount (constant) fractions.  </doc>
  static Fraction one, tf;

  <doc> The forward and backward operations.  </doc>
  static ObjectArray forward, backward;

  <doc> The names for the selector operations in {forward} and {backward}.
      </doc>
  static ObjectArray forward_names, backward_names;

  static int nf, nb;

  <doc> The number of numbers.  </doc>
  static int num_nums;

  <doc> The target number.  </doc>
  const target = 24;
}

<doc> In situ lexicographically next permutation generator, from
    Dijkstra's `Discipline of Programming'.  </doc>
boolean
  nextPerm MutableArray a
{
  /* The lowest index after which A is monotonically decreasing.  */
  int i;
  /* The immediate successor of A[I] is the smallest subsequent
     rightmost entry.  */
  int j;

  for (i = num_nums - 1; i > 0; i--)
    {
      Fraction a1 = a[i], a2 = a[i - 1];

      if ([a1 compare a2] > 0)
	break;
    }

  if (--i < 0)
    {
      /* A already contains the last permutation.  */
      return FALSE;
    }

  for (j = num_nums - 1; [({Fraction f = a[j];}) compare a[i]] <= 0; j--)
    void;
  
  [a swap (i, j)];

  /* A(i..] is made monotonically increasing.  */
  for ({i++; j = num_nums - 1;}; i < j; {i++; j--;})
    [a swap (i, j)];

  = TRUE;
}

(int, int)
   try (int, int) (num, den)
  with MutableArray a
  from int i
{
  if (i == num_nums - 1)
    = [tf equals (num, den)] ? (5, 1) : (0, 0);
  else
    {
      int l, n;

      (l, n) = [self compute (num, den) with a from i + 1];

      if (!!n && l > 4 && ![Fraction integerp (num, den)])
	l = 4;

      = (l, n);
    }
}

(int, int)
  compute (int, int) (num, den)
     with MutableArray a
     from int i
{
  int l, level = 5, n, match = 0;
  Fraction f = a[i];
  Selector op;
  boolean b;
  int j;

  for (j = 0; j < nf; j++)
    {
      (l, n) = [self try [Fraction perform [forward[j] selector]
				   with ((num, den), [f dissect])]
		     with a from i];
      if (n > 0)
	{
	  if (level > l)
	    level = l;
	  match += n;
	}
    }

  for (j = 0; j < nb; j++)
    {
      (l, n) = [self try [Fraction perform [backward[j] selector]
				   with ([f dissect], (num, den))]
		     with a from i];
      if (n > 0)
	{
	  if (level > l)
	    level = l;
	  match += n;
	}
    }

  = (level, match);
}

<doc> In the array {a}, increase the number at index {i} by 1.  If the
    number following {i} is smaller than the new value at {i}, set the
    value at {i} to 1 and increase the next value the same way.

    Return {TRUE} if all combinations have been done, i.e. the number
    following the last number would need to be increased for new
    combinations to be created.  </doc>
boolean
  next MutableArray a
  from int i
{
  Fraction f = a[i];

  if (i == num_nums - 1)
    {
      f = [f add one];
      a[i] = f;
      if ([f compare (10, 1)] >= 0)
	return FALSE;
    }
  else
    {
      Fraction g = a[i + 1];

      f = [f add one];
      if ([f compare g] <= 0)
	a[i] = f;
      else
	{
	  if (![self next a from i + 1])
	    return FALSE;
	  a[i] = one;
	}
    }

  = TRUE;
}

<doc> Emit the usage information and exit.  </doc>
void
  usage
{
  [[[stdio out] print ("usage: ", [Runtime program_name], " <num_nums>")] nl];
  [Runtime exit 1];
}

<doc> The entry point of the program.  </doc>
int
  main Array arguments
{
  MutableObjectArray numbers = [MutableObjectArray alloc], work;
  OutputStream s = [stdio out];
  Date d;
  int i;

  if ([arguments length] != 1 || (num_nums = [arguments[0] intValue]) < 2)
    [self usage];

  d = [Date now];
  [[s print d] nl];

  one = [Fraction with 1];
  tf = [Fraction with target];

  forward = [ObjectArray with
			 ([Selector with selector ((int, int) mul (int, int)
						   with (int, int))],
			  [Selector with selector ((int, int) div (int, int)
						   with (int, int))],
			  [Selector with selector ((int, int) sub (int, int)
						   with (int, int))],
			  [Selector with selector ((int, int) add (int, int)
						   with (int, int))])];
  forward_names = [ObjectArray with ("*", "/", "-", "+")];
  nf = [forward length];
  backward = [ObjectArray with
		        ([Selector with selector ((int, int) div (int, int)
						  with (int, int))],
			 [Selector with selector ((int, int) sub (int, int)
						  with (int, int))])];
  backward_names = [ObjectArray with ("/^-1", "-^-1")];
  nb = [backward length];

  /* Fill the NUMBERS with all ones.  */
  for (i = 0; i < num_nums; i++)
    numbers[i] = one;

  /* Counters for combinations and combinations that work.  */
  int total = 0, possible = 0;

  do
    {
      /* Fill the working array with fresh numbers.  */
      work = [MutableObjectArray withEnumerable numbers];

      do
	{
	  int level, num;

	  (level, num) = [self compute [[work at 0] dissect] with work from 1];

	  if (num > 0)
	    {
//	      for (i = 0; i < num_nums; i++)
//		{
//		  if (!!i)
//		    s = [s print " "];
//		  s = [s print {Any c = [work at i]}]
//		};
//	      s = [[s print (": ", num, ": ", level)] nl];

	      possible++;
	    }
	  total++;
	} while ([self nextPerm work]);
    } while ([self next numbers from 0]);

  [[s print ("total: ", total)] nl];
  [[s print ("possible: ", possible)] nl];
  [[s print [Date now]] nl];
  [[s print ("\ntime taken: ", -[d timeIntervalSinceNow], " seconds")] nl];

  = 0;
}

end;

implementation instance Game
/* Nothing much needed here.  */
end;
