/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: gi.h,v 1.8 1998/01/05 00:56:31 tiggr Exp $  */

#import <config/target.h>
#import <ltt/ltt.h>

/* The version information, as defined in `version.m'.  */
extern char *long_version, *short_version;

/* Iff !0, we should not run GC.  */
extern int flag_inhibit_gc;

/* The number of times `-v' was specified on the command line.  */
extern int flag_verbose;

/* Whether comments and documentation are to be saved.  */
extern int flag_comments, flag_documentation;

/* Iff !0, we're currently not interested in comments.  */
extern int no_comments;

/* The current output file.  If this is NIL, the current file being read
   is not to be output.  */
extern id <TLOutputStream> of;

/* Iff !NIL, this is the unit file we're writing.  */
extern id <TLOutputStream> uf;

/* Iff !0, we're reading the body of a method, and the lexer is supposed
   to skip everything but braces.  */
int num_body_brace;

/* This should not be here.  */
#undef YY_DECL
#define YY_DECL int gi_lex (YYSTYPE *lvalp)

int gi_parse (void);

void parse_file (id <TLString> name, LTTUnit *unit, FILE *f);

const char *indent (int level);

