/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTClass.m,v 1.4 1998/01/05 00:57:55 tiggr Exp $  */

#define LTTCLASS_DECLARE_PRIVATE_METHODS
#import "LTTClass.h"

TLVector *ltt_classes;

@implementation LTTClass

+(id <TLEnumerator>) classes
{
  return [ltt_classes enumerator];
} /* +classes */

+initialize
{
  if (!ltt_classes)
    {
      ltt_classes = [TLVector vector];
      [ltt_classes gcLock];
    }

  return self;
} /* +initialize */

+(id) metaWithName: (id <TLString>) n unit: (LTTUnit *) u;
{
  LTTMeta *m = [super metaWithName: n unit: u];

  if (m)
    [ltt_classes addElement: m];

  return m;
} /* +metaWithName:unit: */

-(BOOL) classp
{
  return YES;
} /* -classp */

-(void) gcReference
{
  MARK (instance);

  [super gcReference];
} /* -gcReference */

-(LTTInstance *) instance
{
  return instance;
} /* -instance */

-(void) setInstance: (LTTInstance *) i
{
  ASGN_IVAR (instance, i);
} /* -setInstance: */

@end
