/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTEntity.h,v 1.6 1998/01/05 00:57:56 tiggr Exp $  */

#import "LTTTop.h"

@class LTTName;

@interface LTTEntity: LTTTop
{
  /* Our name.  */
  LTTName *name;

  /* The object containing our semantical information.  */
  id semantics;
}

-(id) initWithName: (LTTName *) n;

-(LTTName *) lttName;

/* Return the external name.  */
-(id <TLString>) outputName;

-(id) semantics;

-(void) setSemantics: (id) s;

@end
