/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTFile.h,v 1.7 1998/01/20 00:02:20 tiggr Exp $  */

#import "LTTEntity.h"

@class LTTFileItem, LTTUnit;

@interface LTTFile: LTTEntity
{
  /* The unit to which we belong.  */
  LTTUnit *unit;

  /* Extensions defined in/by us.  */
  TLVector *items;

  /* Whether and how this file has been loaded, or is being loaded.  */
  unsigned int loaded_int: 1, loaded_imp: 1, loaded_info: 1;
}

+(LTTFile *) fileWithName: (LTTName *) n unit: (LTTUnit *) u;

-(id) initWithName: (LTTName *) n unit: (LTTUnit *) u;

-(void) addItem: (LTTFileItem *) item;

-(TLVector *) items;

-(BOOL) loadedInfo;
-(void) setLoadedInfo;

-(id <TLString>) interfaceFilename;
-(id <TLString>) implementationFilename;

-(BOOL) loadedInterface;
-(void) setLoadedInterface;

-(BOOL) loadedImplementation;
-(void) setLoadedImplementation;

-(LTTUnit *) unit;

@end
