/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTStringCST.h,v 1.3 1998/01/05 00:58:16 tiggr Exp $  */

#import "LTTEntity.h"

@interface LTTStringCST: LTTEntity
{
  /* The string we're holding.  */
  id <TLString> string;
}

+(LTTStringCST *) stringWithString: (id <TLString>) str name: (id <TLString>) n;

-(id <TLString>) outputDefinitionName;

-(id <TLString>) outputReferenceName;

-(id <TLString>) string;

#ifdef LTTSTRINGCST_DECLARE_PRIVATE_METHODS

-(id) initWithString: (TLString *) str name: (id <TLString>) n;

#endif

@end

@interface LTTStringCST (Semantics)

+(id) semanticsForString: (LTTStringCST *) s;

@end
