%{/* TOM unit file lexer.  -*- objc -*- */
/* Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: lunit.l,v 1.12 1998/01/05 00:58:26 tiggr Exp $  */

#import "ltt.h"
#import "punit.h"

#define ltt_wrap()  1

%}

%option prefix="ltt_"

%%
"class"			{ return CLASS; }
"end"			{ return END; }
"extension"		{ return EXTENSION; }
"file"			{ return _FILE; }
"posing"		{ return POSING; }
"unit"			{ return UNIT; }
"uses"			{ return USES; }

[ \t\f]*\n		{ current_line++; }
[ \t\f]*		{ /* Retry.  */ }

"/*"			{
			  int b = 0, c = input ();
			  int start = current_line;

			  while (c != EOF && !(c == '/' && b == '*'))
			    {
			      if (c == '\n')
				current_line++;
			      b = c;
			      c = input ();
			    }
			  if (c == EOF)
			    error (@"EOF in comment started at line %d", start);

			  /* Retry... */
			}

\"(\\\"|[^\"])*\"	{
			  int nnl;
			  lvalp->v
			    = ltt_lex_string_cst (yytext, yyleng, '"', &nnl);
			  current_line += nnl;
			  return STRING_CST;
			}

[A-Za-z][-A-Za-z_0-9]*[A-Za-z_0-9]|[A-Za-z][A-Za-z_0-9]*	{
			  lvalp->v = [TLString stringWithCString: yytext
					       length: yyleng];
			  return IDENTIFIER;
			}

.			{ return yytext[0]; }

%%
void
ltt_parse_unit (FILE *f)
{
  /* Hack needed when switching back from top-level buffer.  It is not
     allowed to switch to the NULL buffer.  Sigh.  */
  static YY_BUFFER_STATE top;
  YY_BUFFER_STATE pyy_buf = YY_CURRENT_BUFFER;

  yy_switch_to_buffer (yy_create_buffer (f, YY_BUF_SIZE));

  /* Avoid warning about unused yyunput.  */
  { void *v = yyunput; v = *&v; }

  ltt_parse ();

  if (!top)
    top = yy_create_buffer (NULL, 1);
  yy_switch_to_buffer (pyy_buf ? pyy_buf : top);
} /* ltt_parse_unit */
