/* Test ivar index table.  */

struct iit
{
  int offset[1000];
};

struct class
{
  struct class *isa;
  struct iit *iit;
};

struct instance
{
  struct class *isa;
  int simple_value;
};

int index_of_ivar_x;

int
read_ref_iit_pre (struct instance *self)
{
  return *(int *) ((char *) self + self->isa->iit->offset[237]);
}

int
read_ref_iit_dyn (struct instance *self)
{
  return *(int *) ((char *) self + self->isa->iit->offset[index_of_ivar_x]);
}

int
read_ref_direct (struct instance *self)
{
  return self->simple_value;
}

void
mod_ref_iit_pre (struct instance *self, int a)
{
  (*(int *) ((char *) self + self->isa->iit->offset[237])) += a;
}

void
mod_ref_iit_dyn (struct instance *self, int a)
{
  (*(int *) ((char *) self + self->isa->iit->offset[index_of_ivar_x])) += a;
}

void
mod_ref_direct (struct instance *self, int a)
{
  self->simple_value += a;
}
