/* Interface to TLMutableString class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLMutableString.h,v 1.1 1998/01/08 16:13:27 tiggr Exp $  */

#import "TLString.h"

@interface TLMutableString: TLString <TLStream, TLOutputStream>
{
  /* The capacity of the buffer pointed to by C_STRING.  */
  int cap;
}

/******************** string creation ********************/

+(TLMutableString *) mutableString;
+(TLMutableString *) mutableStringWithCapacity: (int) c;
+(TLMutableString *) mutableStringWithFormatVector: (TLVector *) vector;

/******************** initialization ********************/

-initWithCapacity: (int) c;
-initWithFormatVector: (TLVector *) vector;

/******************** direct modification ********************/

-(int) appendCChar: (int) c;
-(int) appendCString: (const char *) s;
-(int) appendCString: (const char *) s length: (int) l;

/* Remove the indicated range of characters.  A negative START in R
   indicates a start from the end of the string.  */
-(id) removeRange: (id <TLRange>) r;

/******************** streams ********************/

/* Grow the receiving string by attempting to read MAX characters from
   STREAM.  Return the number of bytes actually read.  */
-(int) _appendByReading: (int) max fromStream: (id <TLInputStream>) stream;

/* Idem, but return NIL if nothing was appended, instead of 0.  */
-(id <TLNumber>) appendByReading: (id <TLNumber>) max
 fromStream: (id <TLInputStream>) stream;

@end
