/* Interface to TLStream protocol.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStream.h,v 1.1 1998/01/08 16:13:37 tiggr Exp $  */

#import "TLObject.h"

/* The value returned for end-of-file or error condition.  */
#define TL_EOF	-1

@protocol TLStream

-close;

/* Return the ultimate filedescriptor of this stream, or -1 if it not
   associated with one.  */
-(int) fileDescriptor;

/* Return yesss!  */
-streamp;

@end

@protocol TLInputStream

/* Flush any pending input.  */
-flushInput;

/* Read a byte and return it.  Return TL_EOF upon eof or error.  */
-(int) readByte;

/* Read N bytes into the buffer at B.  Return the number of bytes read,
   which is 0 upon EOF, or -1 upon error.  */
-(int) readBytes: (int) n intoBuffer: (char *) b;

@end

@protocol TLBufferedInputStream

/* Unread the byte C.  This will be the first byte to be returned by
   subsequent read operations.  Return the byte, or TL_EOF upon eof or
   error.  */
-(int) unreadByte: (char) c;

/* Unread N bytes from B.  Return the number of bytes actually unread.  */
-(int) unreadBytes: (int) n fromBuffer: (const char *) b;

@end

@protocol TLOutputStream

/* Flushing any pending output.  */
-flushOutput;

/* Write a byte and return it.  Return TL_EOF upon eof or error.  */
-(int) writeByte: (char) c;

/* Write N bytes from the buffer at B.  Return the number of bytes written,
   which is 0 upon EOF, or -1 upon error.  */
-(int) writeBytes: (int) n fromBuffer: (const char *) b;

@end

@protocol TLInputOutputStream <TLInputStream, TLOutputStream>
@end

@protocol TLSeekableStream

-(long) _tell;

enum
{
  TLSEEK_ABSOLUTE,
  TLSEEK_RELATIVE,
  TLSEEK_FROM_END,
};

-(long) _seek: (long) new_offset from: (int) pos;

@end

@protocol TLMutableStream <TLSeekableStream, TLInputOutputStream>

@end

/* Predefined FILE streams.  */
extern id <TLStream, TLInputStream> V_stdin_;
extern id <TLStream, TLOutputStream> V_stdout_;
extern id <TLStream, TLInputOutputStream> V_stderr_;
