/* Interface to TLStreamStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStreamStream.h,v 1.1 1998/01/08 16:13:37 tiggr Exp $  */

#import "TLStream.h"

@interface TLStreamStream: TLObject <TLStream>
{
  /* The stream this stream is abstracting.  */
  id stream;
}

/* Return a new stream abstracting the STREAM.  */
+(id) streamWithStream: (id <TLStream>) stream;

#ifdef TLSTREAMSTREAM_DECLARE_PRIVATE_METHODS

/* Compare by having our STREAM compare.  */
-(int) compare: (id) o;

/* Return the STREAM's filedescriptor, or -1 if we don't have a stream.  */
-(int) fileDescriptor;

-flushInput;

-flushOutput;

/* Reference the STREAM.  */
-(void) gcReference;

/* Designated initializer.  */
-(id) initWithStream: (id <TLStream>) stream;

/* Return Qt.  */
-streamp;

#endif

@end
