/* TL functionality policy.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: policy.h,v 1.2 1998/01/08 17:03:47 tiggr Exp $  */

/* Macro controlling the instantiation of inline functions.  Overridden in
   inline.m to get inline functions instantiated into the library (used for
   calling from gdb).  */
#ifndef __TL_INLINE__
#define __TL_INLINE__	extern __inline__
#endif

/* Type defining alignment of instances on this machine.  This can be
   deduced from the output of malloc(3), but how to do that reliably?
   XXX THIS IS NOT YET SET BY CONFIGURE.  */
#define ALIGN_TYPE	double

/* The integer type suitable for integer arithmetic on pointer values.
   XXX THIS IS NOT YET SET BY CONFIGURE.  */
#define PTR_INT_TYPE	long

/* The type to use to get 32 bits.
   XXX THIS IS NOT YET SET BY CONFIGURE.  */
#define INT32		int

/* Iff !0, provide support for debugging tlisp.  Otherwise, debugging is
   impossible (and tlisp much faster).  */
#define SUPPORT_DEBUG		1

/* Iff >0, the ISA of a deallocated object is saved in the vacant slot,
   and some more paranoid checks are performed.  Iff >1, there is some
   verbosity.  If >2 there are more checks.  Iff >3 is a lot of verbosity.
   Iff >4, some very time consuming checks are installed.  Iff >5, chunk
   administration integrity is checked after each allocation or (partial)
   gc run.  Iff >10 a mega-time consuming check is performed (gray object
   shall reside on gray stack, checked in gcMark).  Any non-zero level
   causes compilation of supporting functions which can display the gc
   data structures.  */
#define DEBUG_GC		2

/* Iff 0, no checking is performed on lockeds (using bits in the TLObject
   instance.  */
#define PARANOID_GCLOCK		1

/* Iff !0, the objc_msg_lookup function is re-declared to have the attribute
   `const'.  It is unclear what the exact net effect of this is...  */
#define CONST_MSG_LOOKUP	0

/* Iff !0, the objc_msg_lookup function is re-declared extern inline, but
   otherwise identical to the GCC 2.7.0 implementation.  */
#define INLINE_MSG_LOOKUP	0

/* Iff !0, we want the nil object to be installed.  This currently only
   works for a modified GNU runtime.  It is not necessary, but has proven to
   be a great debugging aid.  */
#define WANT_NIL_OBJECT		0

/* Iff !0, tl is to be compiled to assume reference counting is provided by
   another library, like GNU libobjects or NeXT's libFoundation.  */
#define HAVE_REFCOUNTING	0
