<copyright> EqDictionary and MutableEqDictionary classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: EqDictionary.t,v 1.8 1998/01/05 01:05:53 tiggr Exp $</id>
    </copyright>

/******************** EqDictionary ********************/

implementation class
EqDictionary: ObjectDictionary, EqHashTable

end;

implementation instance
EqDictionary
      
id
  initWithEnumerator Enumerator e
{
  [self unimplemented cmd];
}

/********** Keyed **********/

/********** Mapped **********/

end;

/******************** MutableEqDictionary ********************/

implementation class
MutableEqDictionary: EqDictionary, MutableEqHashTable, MutableMapped

end;

implementation instance
MutableEqDictionary

/********** MutableKeyed **********/

<doc> Remove the mapping for the {key}.  </doc>
void
  remove All key
{
  int inc = 1, bucket = [key hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketDictElement bucket_elt = buckets[bucket];

  if (!!bucket_elt)
    {
      BucketDictElement ne;
      int delta;

      (ne, delta) = [bucket_elt removeq key];

      if (ne != bucket_elt)
	buckets[bucket] = ne;

      length -= delta;
    }
}

/********** MutableMapped **********/

void
  set All value
   at All key
pre
  value != nil && key != nil
{
  int inc = 1, bucket = [key hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketDictElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketDictElement alloc] initWith (key, value)];
  else
    inc = [bucket_elt addq (key, value)];

  if (inc != 0)
    [self adjust_length inc];
}

end;

/******************** WeakKeyMutableEqDictionary ********************/

<doc> The WeakKeyMutableEqDictionary is identical to a
    MutableEqDictionary, except that when it is a container, the
    references to the keys are weak, whereas in the case of an ordinary
    MutableEqDictionary the value references are weak.  </doc>
implementation class
WeakKeyMutableEqDictionary: MutableEqDictionary

end;

implementation instance
WeakKeyMutableEqDictionary

<doc> Almost identical to {MutableHashTable}'s implementation, but the
    bucket elements are asked to {gc_mark_keys} instead of
    {gc_mark_values}.  </doc>
void
  gc_container_mark_elements
{
  int i, n, len = 1 << size_shift;
  BucketDictElement elt, pe;

  /* Incidentally, we must also mark our BUCKETS, since containers are not
     automatically marked.  */
  [buckets gc_mark];

  for (i = 0; i < len; i++)
    {
      elt = buckets[i];
      if (elt != nil)
	{
	  (pe, n) = [elt gc_mark_keys];
	  if (elt != pe)
	    buckets[i] = pe;
	  length -= n;
	}
    }
}

end;
