<copyright> EqHashTable class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: EqHashTable.t,v 1.5 1998/01/05 01:05:55 tiggr Exp $</id>
    </copyright>

/******************** EqHashTable ********************/

implementation class
EqHashTable: HashTable

end;

implementation instance
EqHashTable

<doc> Return the {key} if present, or {nil} otherwise.  </doc>
Any
  at All key
{
  int bucket = [key hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketElement elt = buckets[bucket];

  = !elt ? nil : [elt memq key];
}

void
  resizing_add BucketElement elt
{
  int bucket = [elt rehashq] * GOLDEN_BITS >>> (32 - size_shift);

  [elt resizing_add buckets[bucket]];
  buckets[bucket] = elt;
}

end;

/******************** MutableEqHashTable ********************/

implementation class
MutableEqHashTable: EqHashTable, MutableHashTable

end;

implementation instance
MutableEqHashTable

void
  add BucketElement elt
{
  int inc = 1, bucket = [elt hashq] * GOLDEN_BITS >>> (32 - size_shift);
  BucketElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = elt;
  else
    inc = [bucket_elt addqElement elt];

  if (inc != 0)
    [self adjust_length inc];
}

end;
