<copyright> Lock class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Lock.t,v 1.7 1998/01/05 01:06:28 tiggr Exp $</id>
    </copyright>

/******************** Lock ********************/

<doc> The abstract lock.  </doc>
implementation class
Lock: State

end;

implementation instance
Lock

deferred void
  lock;

deferred void
  unlock;

<doc> Try to lock, and return {YES} if it succeeded.  </doc>
deferred boolean
  tryLock;

end;

/******************** Simple Lock ********************/

<doc> A simple lock is a binary lock.  </doc>
implementation class
SimpleLock: Lock

end;

implementation instance
SimpleLock
{
  <doc> The underlying lock.  </doc>
  pointer lock;
}

extern void
  dealloc;

<doc> Designated initializer.  </doc>
extern id
  init;

extern void
  lock;

extern void
  unlock;

extern boolean
  tryLock;

end;

/******************** Recursive Lock ********************/

<doc> A recursive lock is a binary lock which can be obtained multiple
    times by the same thread.  </doc>
implementation class
RecursiveLock: Lock

end;

implementation instance
RecursiveLock
{
  <doc> The underlying lock.  </doc>
  pointer lock;
}

extern void
  dealloc;

<doc> Designated initializer.  </doc>
extern id
  init;

extern void
  lock;

extern void
  unlock;

extern boolean
  tryLock;

end;

/******************** Semaphore ********************/

<doc> A semaphore is a lock which can be locked a number of times (1 for a
    binary semaphore) before the next attempt to lock will block.

    When allocated first, the first {lock} will block.  </doc>
implementation class
Semaphore: Lock

<doc> Return a new {Semaphore}, the first {num} {lock} operations will
    succeed.  </doc>
instance (id)
  new int num
{
  = [[self alloc] init num];
}

end;

implementation instance
Semaphore
{
  <doc> Pointer to the underlying structure.  </doc>
  pointer sem;
}

extern void
  dealloc;

<doc> Designated initializer.  </doc>
extern id
  init int num;

<doc> Another initializer.  </doc>
id
  init
{
  = [self init 0];
}

extern void
  lock;

extern void
  unlock;

extern boolean
  tryLock;

end;
