<copyright> MutableByteArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: MutableByteArray.t,v 1.28 1998/01/05 01:06:35 tiggr Exp $</id>
    </copyright>

implementation class
MutableByteArray: ByteArray, MutableArray, OutputStream

end;

implementation instance
MutableByteArray

void
  add byte b
{
  [self set b at length];
}

void
  freeze
{
  //  isa = [ByteArray self];
}

extern id
  initWithCapacity int capacity;

protected id
  initWithEnumerator Enumerator e
{
  [super (ByteArray) initWithEnumerator e];

  capacity = length;

  = self;
}

extern byte
  removeAt int index;

Any
  removeAt int index
{
  byte b = [self removeAt index];

  = Any ([ByteNumber with b]);
}

extern void 
  removeElements (int, int) (start, length);

extern void
  resize (int, int) (start, num);

extern void
  set byte b
   at int index;

// ...
// Tue Oct 15 16:33:30 1996, tiggr@jaguar.ics.ele.tue.nl
void
  set char c
   at int index
{
  [self set byte (c) at index];
}

void
  set All object
   at int index
{
  self[index] = [Number (object) byteValue];
}

extern void
  swap (int, int) (i, j);

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [MutableByteArray self]])
    {
      [super initWithCoder coder];
      capacity = length;
    }
}

/******************** streams ********************/

void
  close
{
  void;
}

extern int
       readRange (int, int) (start, num)
  fromByteStream ByteStream f;

extern int
      readRange (int, int) (start, num)
  fromByteArray ByteArray source
	     to int position;

void
  write byte b
{
  [self add b];
}

int
  write byte b
{
  [self add b];

  = 1;
}

int
  writeBytes int num
        from pointer address
{
  pointer to;

  if (num + length > capacity)
    contents = realloc (contents, capacity = num + length);

  int l = length;
  length += num;
  (to, ) = [self pointerToElements (l, -1)];
  memcpy (to, address, num);
  = num;
}

// Should be a LONG offset, for future use in mapped files.
// Mon Dec 30 18:55:32 1996, tiggr@tricky.es.ele.tue.nl
int
  writeBytes int num
        from pointer address
	  at int offset
{
  pointer to;

  if (offset < 0 || num <= 0)
    return 0;

  if (offset + num > capacity)
    contents = realloc (contents, capacity = num + offset);

  /* Adjust the {length} now since `pointerToElements' will return a NULL
     pointer for a zero-length range.  */
  int old_length = length;
  if (offset + num > length)
    length = offset + num;

  if (offset > old_length)
    {
      (to, ) = [self pointerToElements (old_length, -1)];
      bzero (to, offset - old_length);
    }

  (to, ) = [self pointerToElements (offset, -1)];
  memcpy (to, address, num);

  = num;
}

end;

/******************** Data ********************/

implementation class
Data: MutableByteArray

end;

implementation instance
Data

end;
