<copyright> ObjectArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: ObjectArray.t,v 1.32 1998/12/02 13:45:50 tiggr Exp $</id>
    </copyright>

implementation class
ObjectArray: Array

extern instance (id)
  with dynamic elements;

end;

implementation instance
ObjectArray

protected extern id
  initWithEnumerator Enumerator e;

// In Indexed instead of ObjectArray?
// Wed Dec  2 14:24:40 1998, tiggr@gerbil.org
<doc> Hash some elements.  </doc>
int (v)
  hash
{
  int i, n = length > 32 ? 32 : length;

  for (i = 0; i < n; i++)
    v = (v << 3) ^ [self[i] hash];

  // The rest?
  // Wed Dec  2 14:19:17 1998, tiggr@gerbil.org
  if (length > 32)
    v = v ^ length ^ [self[length - 1] hash];
}

<doc> Compare the elements.  </doc>
boolean
  equal id other
{
  if (self == other)
    return TRUE;
  if (length != [other length])
    return FALSE;

  int i;
  for (i = 0; i < length; i++)
    if (![All (self[i]) equal other[i]])
      return FALSE;

  = TRUE;
}

<doc> Return the object at {index} in the receiving array.  </doc>
extern Any
  at int index
pre
  index >= 0 && index < length
post
  length == old length;

<doc> Return {TRUE}.  </doc>
boolean
  dump_self_p
{
  = YES;
}

<doc> Dump the elements to the stream {s}.  </doc>
void
  dumpSelf MutableKeyed done
    indent MutableByteString prefix
    simple boolean allow_simple
     level int level
	to OutputStream s
{
  int i;

  // Maybe this DONE maintenance should be in `dump indent simple to'.
  // Tue Jul  8 15:06:33 1997, tiggr@natlab.research.philips.com
  [done add self];

  [s print ('(', [isa name], ' ', [self address])];

  for (i = 0; i < length; i++)
    {
      All value = self[i];

      if (!value)
	[s print " *nil*"];
      else if (!done[value] && level != 1)
	[value dump done indent prefix simple allow_simple
	       level level - 1 to [s nl]];
      else
	[s print (" #<", ([value classp] ? [class (State) (value) name]
		   : [[State (value) kind] name]), " ", [value address], ">")];
    }

  [s print ')'];
}

extern int
  elementByteSize;

extern  (pointer, int)
  pointerToElements (int, int) (start, len);

<doc> Set the {object} at the {index} in the receiving array, even if it
    is not a mutable array.  This method <em>must</em> only be used during
    construction of a constant array object.  </doc>
protected void
  setDuringConstruction (int, All) (index, object)
pre
  index >= 0 && index < length
{
  pointer c = contents;
<c>
  ((tom_object *) c)[index] = trt_assign_object_var (self, object);
</c>
}

/******************** copying ********************/
<doc><h4>Copying</h4></doc>

<doc> Return the {MutableObjectArray} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableObjectArray self];
}

<doc> Deepen this copy.  </doc>
extern id
    deepen int level
  mutably: boolean mutable_p = NO;

/******************** coding methods ********************/
<doc><h4>Coding methods</h4></doc>

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [ObjectArray self]])
    {
      [super encodeUsingCoder coder];

      int i, n = length;
      [coder encode n];
      for (i = 0; i < n; i++)
	{
	  State a = self[i];
	  [coder encode a];
	}
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [ObjectArray self]])
    {
      [super initWithCoder coder];

      int i, n = [coder decode];

      length = n;
      contents = [C calloc (n, [self elementByteSize])];
      for (i = 0; i < n; i++)
	[self setDuringConstruction (i, [coder decode])];
    }
}

/******************** garbage collection ********************/
<doc> <h4>Garbage collection</h4> </doc>

<doc> This method is invoked by the garbage collector to have the
    receiving object mark the elements it references.  An {ObjectArray}
    must reference the objects it holds.  </doc>
redefine extern void
  gc_mark_elements;

end;
