<copyright> State class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1998 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: State.t,v 1.59 1998/07/21 14:56:08 tiggr Exp $</id>
    </copyright>

implementation class
State: instance (All)
{
  <doc> Our class.  The `State' class is an instance of the State
      meta-class.  The same is true for every other class.  </doc>
  class (class (State)) isa;

  <doc> Information used, in cunning ways, by the runtime.  </doc>
  private int asi;
}

<doc> Return a newly created instance of the receiving class.  All values,
    apart from the {isa} will have been initialized to their default
    value.  </doc>
extern instance (id)
  alloc;

<doc> Return {TRUE}, since we're a class object.  </doc>
boolean
  classp
{
  = YES;
}

<doc> Return {YES}.  This should not be changed; this method is used in
    situations where it is not known whether the object is a class or not.
    In other situations, where it is known to be a class, this method is
    not invoked as it is known to return {YES}.  </doc>
boolean
  coding-permanent-object-p
{
  = YES;
}

<doc> Return {YES}.  </doc>
boolean
  dump_simple_p
{
  = TRUE;
}

<doc> Return the class of the receiving object, i.e. the value of {isa}.
    </doc>
class (id)
  kind
{
  = isa;
}

<doc> Return the name of this class.  </doc>
extern ByteString
  name;

<doc> Return the number of currently live direct instances of this
    class, non-transitively.  </doc>
int (n)
  num_instances
{
<c>
  n = ((struct trt_class *) self)->info.num_instances;
</c>
}

<doc> Return the unit of this class.  The postcondition states that such a
    unit must exit.  </doc>
// SLOW!
// Thu May  1 16:01:16 1997, tiggr@akebono.ics.ele.tue.nl
Unit (unit)
  unit
post
  unit != nil
{
  Enumerator e = [[Unit units] enumerator];
  String n = [self name];
  boolean b;
  Unit u;

  while ({(b, u) = [e next]; b;})
    if ([u classNamed n] == self)
      return u;

  return nil;
}

<doc> Return a newly created and initialized instance of the receiving
    class.  </doc>
instance (id)
  new
{
  = [[self alloc] init];
}

<doc> Write a description of this class object to the stream {s}.  </doc>
OutputStream
  write OutputStream s
{
  = [[[s print "#<class "] print [self name]] print ">"];
}

end;

implementation instance
State: instance (All)
{
  <doc> Our class.  </doc>
  class (id) isa;

  <doc> Information used, in cunning ways, by the runtime.  </doc>
  private int asi;
}

<doc> Return {FALSE}, as we're an instance, and not a class.  </doc>
boolean
  classp
{
  = NO;
}

<doc> Hard worker for {dump}.  </doc>
protected void
    dump MutableKeyed done
  indent MutableByteString prefix
  simple boolean allow_simple
   level int level
      to OutputStream s
{
  Indexed exts = [self stateExtensions];
  int i, n = [exts length];
  boolean pending_nl;

  [done add self];
  [s print (prefix, "#(", [isa name], " ", [self address])];

  for (i = 0; i < n; i++)
    {
      Extension x = exts[i];
      Indexed vars = [x variables];
      int j, m = [vars length];

      for (j = 0; j < m; j++)
	{
	  String nm = vars[j];

	  if (j != 0 || !["isa" equal nm])
	    {
	      int type = [self typeOfVariableNamed nm from x];
	      All value = [self valueOfVariableNamed nm from x];

	      if (!pending_nl)
		[s print (" ", nm)];
	      else
		{
		  [[s nl] print (prefix, nm)];
		  pending_nl = FALSE;
		}

	      // Constants' TYPEDESC_REFERENCE...
	      // Sun May 17 12:55:10 1998, tiggr@gerbil.org
	      if (type == 10 && value != nil)
		if (level == 1
		    || (allow_simple && [value dump_simple_p]
			&& ![value dump_self_p]))
		  {
		    [s print '='];
		    [value dump_simple s];
		  }
		else
		  {
		    [s print ':'];
		    if (!done[value])
		      {
			[prefix add ' '];
			if ([value dump_self_p])
			  [value dumpSelf done indent prefix
				 simple allow_simple level level - 1 to s];
			else
			  [value dump done indent prefix
				 simple allow_simple level level - 1 to [s nl]];
			[prefix truncate [prefix length] - 1];
			pending_nl = TRUE;
		      }
		    else
		      [s print (" #<",
				([value classp] ? [class (State) (value) name]
				 : [[State (value) kind] name]),
				" ", [value address], ">")];
		  }
	      else
		[s print ("=", value)];
	    }
	}
    }

  [s print ")"];
}

<doc> Designated initializer.  Does nothing.  </doc>
id
  init
{
  = self;
}

<doc> Return the class of the receiving object.  </doc>
class (id)
  kind
{
  = isa;
}

// Not sure about the name, or the name of `kind' above...
// Tue Mar 17 21:50:55 1998, tiggr@gerbil.org
<doc> Change the class of the receiving object (i.e., the {isa}) into the
    {a_class}.  Currently both the original and the new class must carry
    exactly the same state.  Looser restrictions could be implemented...
    </doc>
extern void
  set_kind class (State) a_class;

<doc> Write the class and address of the receiving object to the stream
    {s}.  </doc>
OutputStream
  write OutputStream s
{
  s = [[[[s print "#<"] print [isa name]] print ' '] print [self address]];
  s = [self writeFields s];
  = [s print ">"];
}

<doc> Subsidiary for {write} to allow subclasses to write their fields to
    the stream {s}.  The default implementation does nothing.  </doc>
OutputStream
  writeFields OutputStream s
{
  = s;
}

/******************** garbage collection ********************/
<doc> <h4>Garbage collection</h4> </doc>

<doc> Invoked by the garbage collector when an object has become garbage.
    Some important notes apply to this method:

    Do not message any other objects from within this method as they might
    have become garbage too.

    Since class objects can not become garbage, it is safe to message
    class objects.

    When overriding this method, it is not necessary to invoke {State}'s
    implementation.  </doc>
void
  dealloc
{
  void;
}

<doc> This method is invoked by the garbage collector for instances which
    employ pointer typed instance variables, to have the receiving object
    mark the elements it references through said pointers.  The default
    implementation marks the object referencing variables.  </doc>
extern void
  gc_mark_elements;

end;
