<copyright> Thread class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Thread.t,v 1.12 1998/09/28 09:56:17 tiggr Exp $</id>
    </copyright>

<doc> The {Thread} class provides an abstraction to the multi-threading
    facilities provided by the underlying operating system.

    A new thread is started by the {performInThread with} method provided
    by the instance {All}.  The value returned by that method is the
    {Thread} object of the newly created thread.

    Every thread has an id.  The id of the current thread is available
    from the {Thread} class as {current_id}.  The main thread (which every
    program has, even when running single-threaded) has id 0.  Due to the
    differences in target implementations, exiting the main thread, by
    invoking that {Thread}'s {exit} method, is not guaranteed not to exit
    the program.

    Multi-threading need not be available on all TOM targets.  The
    {functioning} method returns {FALSE} on those targets on which
    multi-threading is not available.  However, a TOM programmer can
    assume multi-threading to always be available.  </doc>
implementation class
Thread: State
{
  <doc> The currently existing threads.  </doc>
  static MutableEqSet threads;

  <doc> The current thread.  </doc>
  local static public instance (id) current;

  <doc> The id of the current thread.  </doc>
  local static public int current_id;
}

<doc> Return {TRUE} iff we can run multiple threads on this target.  </doc>
extern boolean
  functioning;

<doc> Return the currently existing threads.  </doc>
Set
  threads
{
  = threads;
}

end;

implementation instance
Thread
{
  <doc> The TOM thread id of this thread.  </doc>
  public int thread_id;
}

<doc> Exit the receiving thread, which must be the current thread.  </doc>
extern void
  exit int rc
pre
  self == [Thread current];

<doc> Designated initializer.  </doc>
protected id (self)
  init int th_id
{
  thread_id = th_id;
}

end;
