/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMArgument.m,v 1.6 1998/01/05 01:12:04 tiggr Exp $  */

#define OTMARGUMENT_DECLARE_PRIVATE_METHODS

#import "OTMArgument.h"
#import "OTMCustomMethod.h"

@implementation OTMArgument

+(OTMArgument *) variableWithName: (id) n
			     type: (OTMType *) t
			   number: (int) x
{
  OTMArgument *arg = (id) [super variableWithName: n type: t];
  [arg setArgumentNumber: x];
  return arg;
}

+(OTMVariable *) temporaryVariableWithType: (OTMType *) t
				    number: (int) x
{
  return [self variableWithName: formac (nil, @"_%d_", next_tmp++)
	       type: t number: x];
}

-(id) conditionCopyFor: (OTMCustomMethod *) method
{
  return [method argumentNumbered: number];
}

-(void) declareReturnArguments: (int) n
{
  if (number >= n)
    init_local_var (self, type, nil);
}

-(BOOL) argumentp
{
  return YES;
}

-(int) argumentNumber
{
  return number;
}

-(OTMArgument *) argumentNumbered: (int) n
{
  return number == n ? self : nil;
}

-(void) setArgumentNumber: (int) n
{
  number = n;
}

@end
