/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMBuiltinMethod.h,v 1.14 1998/01/05 01:12:18 tiggr Exp $  */

#ifdef OTMBUILTINMETHOD_DECLARE_PRIVATE_METHODS
#define OTMMETHOD_DECLARE_PRIVATE_METHODS
#endif
#import "OTMMethod.h"

enum builtin_operator
{
  /* Unary operators.  */
  BO_NEG,
  BO_INV,
  BO_NOT,

  /* Binary operators.  */
  BO_MUL,
  BO_DIV,
  BO_MOD,
  BO_ADD,
  BO_SUB,

  BO_SHL,
  BO_SHR,
  BO_LSR,

  BO_AND,
  BO_OR,
  BO_EOR,

  BO_LT,
  BO_LE,
  BO_NE,
  BO_EQ,
  BO_GE,
  BO_GT,

  BO_SC_AND,
  BO_SC_OR,
  BO_IMPLIES,

  BO_NUM
};

/* The uniqued operator names of the above.  */
extern id <TLString> builtin_operator_name[];

@interface OTMBuiltinMethod: OTMMethod
{
  enum builtin_operator op;
}

+(void) init;

+(OTMBuiltinMethod *) methodWithExtension: (OTMExtension *) extension
				nameTypes: (TLCons *) nt
			       returnType: (id) rt
				 operator: (enum builtin_operator) op;

-(enum builtin_operator) operator;

#ifdef OTMBUILTINMETHOD_DECLARE_PRIVATE_METHODS

-initWithExtension: (OTMExtension *) extension
	 nameTypes: (TLCons *) nt
	returnType: (id) rt
	  operator: (enum builtin_operator) op;

#endif

@end
