/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCompound.h,v 1.16 1998/01/05 01:12:28 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMVariable, OTMLoop;

@interface OTMCompound: OTMExpr
{
  /* The value we shall have (i.e. the value of the last expression
     contained in us).  */
  OTMExpr *value;

  /* The temporaries holding the result.  */
  OTMExpr *result;

  /* The containing compound.  This can also be a method.  */
  OTMCompound *container;

  /* Statements in this compound.  In order.  */
  TLVector *stats;

  /* The variables declared in this compound.  */
  TLDictionary *vars;

  /* The temporaries available for usage.  */
  TLVector *temp_free;

  /* The temporaries in use.  */
  TLVector *temp_use;
}

+(OTMCompound *) compoundWithContainer: (id) c;

/* Designated initializer.  */
-(id) initWithContainer: (id) c;

-(void) compile;

/* If we're a loop, this compiles the condition of the loop.  */
-(void) compileCondition: (BOOL) end_not_start;

/* If we're a loop, this sets the return result to the value V.
   Otherwise, it is passed to the container.  */
-(void) setBreakValue: (OTMExpr *) e;

-(OTMLoop *) loopForContinue: (int) level;

-(void) startLoopEnd;

/* Actually, this is a compound or a method.  */
-(OTMCompound *) container;

-(void) addStatement: (id) stmt;

/* Add the variable to this compound.  Error if it is a redeclaration.  */
-(void) addVariable: (OTMVariable *) v;

/* Search for the variable with the NAME, trying the enclosing compound on
   failure.  */
-(OTMVariable *) searchVariableNamed: (id <TLString>) name;

/* Set the current notion of the compound value.  */
-(void) setValue: (OTMExpr *) v;

/* Emit an assignment to the result of the value V.  */
-(void) assignResult: (OTMExpr *) v;

-(OTMExpr *) value;

/********** temporary variables **********/

-(OTMVariable *) temporaryWithType: (OTMType *) t;

-(void) releaseTemporaryVariables;

@end
