/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMLocalVar.m,v 1.10 1998/01/05 01:13:14 tiggr Exp $  */

#define OTMLOCALVAR_DECLARE_PRIVATE_METHODS

#import "OTMLocalVar.h"
#import "OTMType.h"
#import "global.h"

@implementation OTMLocalVar

#if STACK_PROTECT == SP_PROT
-(void) compileAssignment: (OTMExpr *) rhs
{
  if (flag_atomic_gc || ![type isObjectType])
    [super compileAssignment: rhs];
  else
    formac (of, @"%@%@ = %@ (%@);", [self nl], [self outputReference],
	    TO_TRT_ASSIGN_LOCAL, [rhs result]);
}
#endif

-(id) outputReference
{
#if STACK_REF_STRUCT
  if ([type isObjectType])
    return formac (nil, @"%@.%@", TO_PROTECT_STACK, name);
#endif

  return name;
}

#if STACK_REF_STRUCT
-(BOOL) residesInRefStruct
{
  return [type isObjectType];
}
#endif

@end
