/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMObjectVar.h,v 1.10 1998/01/05 01:13:32 tiggr Exp $  */

#ifdef OTMOBJECTVAR_DECLARE_PRIVATE_METHODS
#define OTMVARIABLE_DECLARE_PRIVATE_METHODS
#endif

#import "OTMVariable.h"
#import "global.h"

@class OTMExtension;

@interface OTMObjectVar: OTMVariable
{
  /* The object to which we add space.  */
  OTMExtension *ext;

  /* Iff !0, we're local to each thread.  */
  unsigned int th_local: 1;
}

+(OTMObjectVar *) variableWithExtension: (OTMExtension *) e
				   name: (TLString *) n
				   type: (OTMType *) t
			     qualifiers: (otm_qualifiers) q;

-(void) compileDeclaration;

-(void) dumpInfo: (id <TLOutputStream>) s;

-(OTMExtension *) extension;

-(void) setIsThreadLocal;
-(BOOL) isThreadLocal;

#ifdef OTMOBJECTVAR_DECLARE_PRIVATE_METHODS

/* Designated initializer.  */
-(id) initWithExtension: (OTMExtension *) e
		   name: (TLString *) n
		   type: (OTMType *) t
	     qualifiers: (otm_qualifiers) q;

#endif

@end
