/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMSelector.m,v 1.10 1998/01/05 01:13:46 tiggr Exp $  */

#define OTMSELECTOR_DECLARE_PRIVATE_METHODS
#import "OTMSelector.h"
#import "OTMBasic.h"
#import "global.h"

@implementation LTTSelector (Semantics)

+(id) semanticsForSelector: (LTTSelector *) sel
{
  return [[CO_OTMSelector alloc] initWithStructure: sel];
}

@end

@implementation OTMSelector

-(void) compileDeclaration
{
  if (![self declarationOutputp])
    {
      [self setDeclarationOutputP: YES];
      formac (of, @"extern struct trtd_selector %@;\n",
	      [structure outputDefinitionName]);
      [structure noteUsage];
    }
}

-(void) gcReference
{
  MARK (structure);

  [super gcReference];
}

-(id) initWithStructure: (LTTSelector *) sel
{
  if (![super initWithType: basic_type[BT_SELECTOR]])
    return nil;

  structure = sel;

  return self;
}

-precompile
{
  [self compileDeclaration];

  return [super precompile];
}

-(id <TLString>) result
{
  return formac (nil, @"&%@", [structure outputDefinitionName]);
}

-(LTTSelector *) structure
{
  return structure;
}

@end
