/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: TLPatches.m,v 1.22 1998/01/05 01:14:16 tiggr Exp $  */

#import "TLPatches.h"
#import "OTMTop.h"
#import "OTMBasic.h"
#import "OTMExpr.h"
#import <config/target.h>

/* Global variable to have these patches be pulled in on systems with a
   linker lacking a switch for `-ObjC' semantics.  */
int get_patches;

@implementation TLObject (OTM)

-(void) compileStatement
{
  [(id) self compile];
}

-(OTMExpr *) value
{
  return (id) self;
}

@end

@implementation TLNumber (OTM)

-(void) compile
{
}

-(BOOL) constantp
{
  return YES;
}

-(id) elaborate
{
  return self;
}

-(BOOL) isTuple
{
  return NO;
}

-(id) precompile
{
  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  return default_resolve_expr ([self type], expected, to, cxt, indices, index);
}

-(id <TLString>) result
{
  switch (encoding)
    {
    case 'l':
      return formac (nil, @"%@L", self);
    case 'q':
      return formac (nil, @"%@LL", self);
    default:
      break;
    }
  return (id) self;
}

-(id) type
{
  switch (encoding)
    {
    case 'c': return basic_type[BT_BYTE];
    case 's': return basic_type[BT_CHAR];
    case 'i': return basic_type[BT_INT];
    case 'q': return basic_type[BT_LONG];
    case 'f': return basic_type[BT_FLOAT];
    case 'd': return basic_type[BT_DOUBLE];
    default:
      internal (@"unknown TLNumber encoding `%c' (%d)", encoding, encoding);
    }

  return nil;
}

@end

@implementation TLString (OTM)

-(BOOL) constantp
{
  return YES;
}

-(id) elaborate
{
  return self;
}

@end

/* XXX YYY ZZZ  */
#ifdef SOMETHINGS_VERY_WRONG_WITH_THE_GNU_RUNTIME

@implementation TLObject (FooBar)

-equal: o
{
  return ![self compare: o] ? self : nil;
}

-consp { return (nil); }
-emptyp { return (nil); }
-floatp { return (nil); }
-integerp { return (nil); }
-lambdap { return (nil); }
-listp { return (nil); }
-nilp { return (nil); }
-sequencep { return (nil); }
-stackp { return (nil); }
-stringp { return (nil); }
-streamp { return (nil); }
-subroutinep { return (nil); }
-symbolp { return (nil); }

@end

#endif
