<copyright> Managing objects on a wire.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: PortCoder.t,v 1.7 1998/01/05 01:16:45 tiggr Exp $</id>
    </copyright>

/******************** Encoder (PortCoder) ********************/

implementation class
Encoder extension PortCoder

end;

implementation instance
Encoder extension PortCoder

<doc> Encode a {Proxy}.  If this is for archiving purposes, this does
    nothing and returns {FALSE} (the default implementation).  Otherwise,
    in case of wiring, it actually performs the proxy encoding and returns
    {TRUE}.  </doc>
boolean
  encodeProxy All p
{
  = FALSE;
}

end;

/******************** PortCoder ********************/

implementation class
PortCoder: BinaryCoder

end;

implementation instance
PortCoder
{
  <doc> The {Connection} for which we operate.  </doc>
  public ConnectedConnection connection;

  <doc> Our buffered view of the socket in the direction we handle.
      </doc>
  ConnectedPort port;
}

<doc> Designated initializer.  </doc>
id
  initWithConnection ConnectedConnection c
{
  connection = c;

  port = Any ([BufferedStream with [connection port]]);

  = [super init];
}

end;
