/*
notebook Form
implementation file:notebook.cc
*/
#include <notebook.h>
// Notebook FORM  CLASS
/*
form constructor
*/
NotebookForm::NotebookForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
form destructor
*/
NotebookForm::~NotebookForm()
{
}

/*
form setup
*/
const int MAX_ADDR = 6 ;
const int MAX_COL = 5;

typedef struct { char *items[MAX_COL]; } ynad;

ynad friends[MAX_ADDR]=
{
  {{"Motta","Mario","via delle fonti 1","Montecolombo","98564"}},
  {{"Guerra","Tonino","via Arcangelo 6","Morciano","34567"}},
  {{"Plum","Adam","Strawberry street 678","Los Angeles","CA4567"}},
  {{"Jim","Uncle","Sky boulevard 34", "Paris", "FR5676"}},
  {{"Adelante", "Speedo","fast plaza", "Madrid","SP98767"}},
  {{"Streisand","Barbara","Star hill 567","Hollywood", "XX5676"}}
};

/*
*/
void 
NotebookForm::Setup(void)
{
  int t = 0;   
  GUISetup(); // vdkb gui setup
// put your code below here
  list->ActiveTitle(0,false);
  list->Titles[0]->NormalBackground = clLightBlue;
   // load address
  for(;t < MAX_ADDR;t++) 
     list->AddRow(friends[t].items);
  list->SelectRow(0,0);
  // disables last page
  book->Pages[1]->TabLabel->Enabled = false;
}

// signal response method 
bool
NotebookForm::OnquitClick(VDKObject* sender)
{
Close();
return true;
}

// signal response method 
bool
NotebookForm::OnlistSelectRow(VDKObject* sender)
{
int ndx = list->Selected.Row();
if(ndx >= 0)
  {
    firstname->Text = friends[ndx].items[1];
    address->Text = friends[ndx].items[2];
    city->Text = friends[ndx].items[3];
    phonenumber->Text = friends[ndx].items[4];
  }
return true;
}

// signal response method 
bool
NotebookForm::OnenableClick(VDKObject* sender)
{
  book->Pages[1]->TabLabel->Enabled = true;
  return true;
}

// signal response method 
bool
NotebookForm::OnnextabClick(VDKObject* sender)
{
  book->ActivePage++; 
  return true;

}

// signal response method 
bool
NotebookForm::OnprevtabClick(VDKObject* sender)
{
  book->ActivePage--; 
  return true;
}

// signal response method 
bool
NotebookForm::OnrotatetabClick(VDKObject* sender)
{
  static int pos = 0;
  book->TabPosition = ++pos;
  return true;
}
