/*
 * ===========================
 * VDK Builder
 * Version 1.0.3
 * Revision:
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_widclipboard_h
#define _vdkb_widclipboard_h
#include <vdk/value_sem_list.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_evcontain.h>
#include <vdk/vdkarray.h>
/*
widget clipboard item
*/

class VDKBWidgetClipboardItem
{
 public:
  VDKBObject* object;
  VDKBEventContainer* container;
  GtkWidget* widget;
  GtkWidget* parent;
  VDKBWidgetClipboardItem(
			  VDKBObject* object = NULL,
			  VDKBEventContainer* container = NULL,
			  GtkWidget* widget = NULL,
			  GtkWidget* parent = NULL):
    object(object),
    container(container),
    widget(widget),
    parent(parent)
    {}
  ~VDKBWidgetClipboardItem() {}
  bool operator==(VDKBWidgetClipboardItem& item)
  {
    return object == item.object; 
  }

};

/*
global widget clipboard
*/

typedef 
VDKValueList<VDKBWidgetClipboardItem> VDKBWidClip;

typedef 
VDKValueListIterator<VDKBWidgetClipboardItem> VDKBWidgetClipboardIterator;

typedef VDKArray<VDKBWidgetClipboardItem> VDKBWidgetClipboardArray;

class VDKBWidgetClipboard: public VDKBWidClip
{
 public:
  VDKBWidgetClipboard() {}
  ~VDKBWidgetClipboard() {}
  void CutWidget(VDKObject* cut);
  void CopyWidget(VDKObject* copy);
  void DeepCopyWidget(VDKObject* obj);
  void RecursiveDeepCopyWidget(VDKObject* obj);
  void PasteWidget(VDKObject* paste, 
		   int ndx, 
		   bool reset_wi = true);
  VDKObject* ChildWithName(char* name);
};
/*
global widget clipboard address
*/
extern VDKBWidgetClipboard* WidgetClipboard;

#endif
