(**
  A simple "Hello world!" demo for VisualOberon.
**)

MODULE Button;

(*
    Demo for VisualOberon. Prints "Hello world" into a window.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,      (* The button class *)
       D   := VODisplay,     (* Display stuff *)
       G   := VOGUIObject,   (* GUI object baseclass *)
       I   := VOImage,
       P   := VOPanel,       (* Panel object *)
       S   := VOSpace,
              VOUsePrefs,    (* The use the preferences setting *)
       W   := VOWindow,      (* Window class *)
       WG  := VOWindowGroup, (* The window group object *)

              Err;           (* Simple error IO *)


VAR
  d          : D.Display;      (* The instance display class *)
  w          : W.Window;       (* The window *)

  button     : B.Button;
  image      : I.Image;
  space      : S.Space;
  horiz      : P.Panel;
  wGroup     : WG.WindowGroup; (* The window group *)

  msg2Exit   : D.Msg2Exit;     (* a simple message converter *)


BEGIN
  (*
    Allocate an instance of the display class,
    you need only one per application
  *)
  NEW(d);

  (*
    Try to initialize it.
    This call make the connection to the X server and allocates
    fonts, colors and that stuff
  *)
  IF ~d.InitDisplay("HelloWorld") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  (*
    Allocate an instance of the window group class.
    This group handles positioning of menustrip and window contents.
  *)
  NEW(wGroup);
  
  (* Every instance must be initialized *)
  wGroup.Init;
  wGroup.SetFlags({G.horizontalFlex,G.verticalFlex});

    NEW(horiz);
    horiz.Init;
    horiz.Set(P.horizontal);
    horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(button);
      button.Init;
      button.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(image);
        image.Init;
        image.SetFlags({G.horizontalFlex,G.verticalFlex});
        image.SetFilename("xpm/left.xpm");

        button.SetLabelText("_Back^",NIL);
(*       button.SetImage(image);*)
       
     horiz.Add(button);
(*
       NEW(space);
       space.Init;
       space.Set(FALSE,S.normal);
       space.SetFlags({G.horizontalFlex});
     horiz.Add(space);

      NEW(button);
      button.Init;
      button.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(image);
        image.Init;
        image.SetFlags({G.horizontalFlex,G.verticalFlex});
        image.SetFilename("xpm/current.xpm");

  (*      button.SetText("O");*)
       button.SetImage(image);
       
     horiz.Add(button);

       NEW(space);
       space.Init;
       space.Set(FALSE,S.normal);
       space.SetFlags({G.horizontalFlex});
     horiz.Add(space);

      NEW(button);
      button.Init;
      button.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(image);
        image.Init;
        image.SetFlags({G.horizontalFlex,G.verticalFlex});
        image.SetFilename("xpm/right.xpm");

  (*      button.SetText(">");*)
       button.SetImage(image);
       
     horiz.Add(button);
*)
  wGroup.Set(NIL,horiz,TRUE);

  (* Create an instance of the window class *)
  NEW(w);

  (* Initialize it *)
  w.Init;

  (* Assign the display to the window *)
  w.SetDisplay(d);

  (* Set the top object of the window to the window group *)
  w.SetTop(wGroup);

  (* Set the title of the window *)
  w.SetTitle("Button");

  (*
    Allocate an instance of this special message handler.
    A handler is a class that can convert any or a special
    input message to an other message and sends the resulting
    message to the given destination. However the baseclas just
    returns the input message.

    Most converters are handwritten, but some special converters are
    given by the corresponding objects.

    This converter converts the close-message generated when clicking
    the closing gadget of the window to an exist-message of the display
    class.
  *)
    NEW(msg2Exit);

  (*
    Send the resulting exit message to the display, which will finish
    the event loop and receiving.
  *)
  msg2Exit.destination:=d;

  (*
    Add the handler to window and tell the window that it should call
    this hndler when a close message gets send.
  *)
  w.AddHandler(msg2Exit,W.closeMsg);

  (* Open the main window *)
  w.Open;

  (*
    Start the main event loop. The event loop will get finished when
    the display receives a close message or its exit method gets called.
  *)
  d.Handler;

  (* Free possible ressources of the display. *)
  d.Deinit;
END Button.