(**
   Some macros for the lowlevel-stuff defined in @file{VOLLInt.Mod}
**)

MODULE VOLLMac;

(*
    Macros for lowlevel stuff in VOLLInt.Mod.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT LI := VOLLInt,

       C;

  (**
     Deletes @var{fd} from @var{set}.
  **)

  PROCEDURE FD_CLR*(fd : C.int; VAR set : LI.fd_set);

  BEGIN
    EXCL(set.set[fd DIV (MAX(SET)+1)],fd MOD (MAX(SET)+1));
  END FD_CLR;

  (**
     Checks if @var{fd} is included in @var{set}.
  **)

  PROCEDURE FD_ISSET*(fd : C.int; VAR set : LI.fd_set):BOOLEAN;

  BEGIN
    RETURN (fd MOD (MAX(SET)+1)) IN set.set[fd DIV (MAX(SET)+1)];
  END FD_ISSET;

  (**
     Sets @var{fd} in @var{set}.
  **)

  PROCEDURE FD_SET*(fd : C.int; VAR set : LI.fd_set);

  BEGIN
    INCL(set.set[fd DIV (MAX(SET)+1)],fd MOD (MAX(SET)+1));
  END FD_SET;

  (**
     Clears @var{set} out.
  **)

  PROCEDURE FD_ZERO*(VAR set : LI.fd_set);

  VAR
    x : LONGINT;

  BEGIN
    FOR x:=0 TO LEN(set.set)-1 DO
      set.set[x]:={};
    END;
  END FD_ZERO;

END VOLLMac.