(**
  A module for creating simple dialogs for displaying
  modal messages and getting simple user response.

  TODO
  Preferences for imgaes to use.
**)

MODULE VOMsgDialog;

(*
    A Module for simple dialogs.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BR  := VOButtonRow,
       D   := VODisplay,
       G   := VOGUIObject,
       KH  := VOKeyHandler,
       O   := VOObject,
       P   := VOPanel,
       S   := VOSpace,
       T   := VOText,
       U   := VOUtil,
       V   := VOVecImage,
       W   := VOWindow,
       WG  := VOWindowGroup,

       str := Strings;

CONST
  (* various image types *)
  none     * = 0;
  warning  * = 1;
  info     * = 2;
  atention * = 3;
  question * = 4;


TYPE
  MsgDialog*     = POINTER TO MsgDialogDesc;
  MsgDialogDesc* = RECORD (W.WindowDesc)
                     text    : U.Text;
                     button  : U.Text;
                     type    : LONGINT;
                     result- : LONGINT;
                   END;

  PROCEDURE (d : MsgDialog) Init*;

  VAR
    keyHandler : KH.KeyHandler;

  BEGIN
    d.Init^;

    d.CreateAllways(TRUE);

    d.text:=NIL;

    NEW(keyHandler);
    keyHandler.Init;
    d.AddKeyHandler(keyHandler);

    d.SetModal;
  END Init;

  (**
    Set the text to display in the dialog, the buttons to be showed and
    the image.

    PARAMETER
    Text can use any escape sequences supported by VOText, button consists
    of a list of button labels ("_","*","^" and "#" are supported) devided
    by "|" and type can be one of the constants defined in this module.
  **)

  PROCEDURE (d : MsgDialog) SetText*(text,button : ARRAY OF CHAR; type : LONGINT);

  BEGIN
    NEW(d.text,str.Length(text)+1);
    COPY(text,d.text^);
    NEW(d.button,str.Length(button)+1);
    COPY(button,d.button^);
    d.type:=type;
  END SetText;

  PROCEDURE (d : MsgDialog) PreInit*;

  VAR
    vPanel,
    hPanel  : P.Panel;
    image   : V.VecImage;
    button  : B.Button;
    row     : BR.ButtonRow;
    space   : S.Space;
    wGroup  : WG.WindowGroup;
    label   : ARRAY 256 OF CHAR;
    length,
    a,b,pos : LONGINT;

  BEGIN
    NEW(vPanel);
    vPanel.Init;
    vPanel.Set(P.vertical);

      NEW(hPanel);
      hPanel.Init;
      hPanel.Set(P.horizontal);
      hPanel.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(image);
      image.Init;
      CASE d.type OF
        info:
          image.Set(V.info);
      | atention:
          image.Set(V.atention);
      | warning:
          image.Set(V.warning);
      | question:
          image.Set(V.question);
      END;
      hPanel.Add(image);
      NEW(space);
      space.Init;
      space.Set(FALSE,S.huge);
      hPanel.Add(space);

      IF d.text#NIL THEN
       hPanel.Add(T.MakeLeftText(d.text^));
      END;

    vPanel.Add(hPanel);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    vPanel.Add(space);

      NEW(row);
      row.Init;
      row.SetFlags({G.horizontalFlex});

      IF d.button#NIL THEN
        length:=str.Length(d.button^);
        a:=0;
        b:=0;
        pos:=0;

        WHILE b<length DO
          IF d.button[b]="|" THEN
            str.Extract(d.button^,SHORT(a),SHORT(b-a),label);

            NEW(button);
            button.Init;
            button.SetFlags({G.horizontalFlex,G.verticalFlex});
            button.SetLabelText(label,d.keyHandler);
            button.SetId(pos);
            button.Forward(B.pressedMsg,d);
            d.keyHandler.AddFocusObject(button);
            row.Add(button);

            a:=b+1;
            INC(b);
            INC(pos);
          ELSE
            INC(b);
          END;
        END;

        IF a<length-1 THEN
          str.Extract(d.button^,SHORT(a),SHORT(length-a),label);

          NEW(button);
          button.Init;
          button.SetFlags({G.horizontalFlex,G.verticalFlex});
          button.SetLabelText(label,d.keyHandler);
          button.SetId(pos);
          button.Forward(B.pressedMsg,d);
          d.keyHandler.AddFocusObject(button);
          row.Add(button);
        END;
      END;
    vPanel.Add(row);

    NEW(wGroup);
    wGroup.Init;
    wGroup.Set(NIL,vPanel,TRUE);

    d.SetTop(wGroup);

    d.Forward(W.closeMsg,d);

    d.PreInit^;
  END PreInit;

  PROCEDURE (d : MsgDialog) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
        d.result:=message.source.id;
        d.Close;
    | message : W.CloseMsg DO
        d.Close;
    ELSE
      d.Receive^(message);
    END;
  END Receive;

  PROCEDURE Dialog*(display : D.Display; parent : D.Window; title,text,button : ARRAY OF CHAR; type : LONGINT):MsgDialog;

  VAR
    msgDialog : MsgDialog;

  BEGIN
    NEW(msgDialog);
    msgDialog.Init;
    msgDialog.SetDisplay(display);
    msgDialog.SetParent(parent);
    msgDialog.SetPosition(D.centerOnParent,D.centerOnParent);
    msgDialog.SetTitle(title);
    msgDialog.SetText(text,button,type);
    msgDialog.Open;
    msgDialog.Go;
    RETURN msgDialog;
  END Dialog;

END VOMsgDialog.