MODULE VOTablePrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       T   := VOTable;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs           : T.PrefsDesc;
                frmSelDlg       : FSD.FrmSelDlg;
                headerFrmSelDlg : FSD.FrmSelDlg;
                focusFrmSelDlg  : FSD.FrmSelDlg;
                frame           : F.Frame;
                headerFrame     : F.Frame;
                focusFrame      : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Table";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;

    NEW(d.headerFrmSelDlg);
    d.headerFrmSelDlg.Init;

    NEW(d.focusFrmSelDlg);
    d.focusFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=T.prefs^;

    d.frame.SetInternalFrame(d.prefs.frame);
    d.headerFrame.SetInternalFrame(d.prefs.headerFrame);
    d.focusFrame.SetInternalFrame(d.prefs.focusFrame);

    d.frmSelDlg.SetFrame(d.prefs.frame);
    d.headerFrmSelDlg.SetFrame(d.prefs.headerFrame);
    d.focusFrmSelDlg.SetFrame(d.prefs.focusFrame);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FG.FrameGroup;
    label     : L.Label;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.frmSelDlg.Forward(FSD.setMsg,d);

    d.headerFrmSelDlg.SetDisplay(d.display);
    d.headerFrmSelDlg.Forward(FSD.setMsg,d);

    d.focusFrmSelDlg.SetDisplay(d.display);
    d.focusFrmSelDlg.Forward(FSD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Frames");

      NEW(label);
      label.Init;

        button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                     d.window.keyHandler,"Select table frame");
      label.AddTextLabel("frame",button);

      button:=PG.CreateFrameButton(d.prefs.headerFrame,d.headerFrame,d.display,d.headerFrmSelDlg,
                                   d.window.keyHandler,"Select header frame");
      label.AddTextLabel("header frame",button);

      button:=PG.CreateFrameButton(d.prefs.focusFrame,d.focusFrame,d.display,d.focusFrmSelDlg,
                                   d.window.keyHandler,"Select focus frame");
      label.AddTextLabel("focus frame",button);
    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Table",appName);

    IF top#NIL THEN
      IF top.GetStringEntry("TABLE/frame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          T.prefs.frame:=pos;
        ELSE
          p.ErrorWrongData("TABLE/frame",buffer);
        END;
      END;

      IF top.GetStringEntry("TABLE/headerFrame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          T.prefs.headerFrame:=pos;
        ELSE
          p.ErrorWrongData("TABLE/headerFrame",buffer);
        END;
      END;

      IF top.GetStringEntry("TABLE/focusFrame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          T.prefs.focusFrame:=pos;
        ELSE
          p.ErrorWrongData("TABLE/focusFrame",buffer);
        END;
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    T.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("TABLE");
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("headerFrame",F.internalFrames[p.prefs.headerFrame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("focusFrame",F.internalFrames[p.prefs.focusFrame]);
    block.AddItem(value);

    p.SaveItems("Table",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        IF message.source=p.frmSelDlg THEN
          p.frame.SetInternalFrame(message.frame);
          p.prefs.frame:=message.frame;
        ELSIF message.source=p.headerFrmSelDlg THEN
          p.headerFrame.SetInternalFrame(message.frame);
          p.prefs.headerFrame:=message.frame;
        ELSE
          p.focusFrame.SetInternalFrame(message.frame);
          p.prefs.focusFrame:=message.frame;
        END;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOTablePrefs.