/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_asc_parse.c,v 1.5 1999/11/08 06:20:22 bbarrett Exp $
 *
 *	Function:	- parse an application schema
 */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
        
#include "all_list.h"
#include "app_schema.h"
#include "lam.h"

#include "xmpi.h"

LIST *
xmpi_asc_parse(appfile)

XMPI_CONST char		*appfile;

{
	struct stat	fileinfo;		/* file information */
	LIST		*appd;			/* app. schema desc. */
	int		lineno = 0;		/* line number */
	char		ebuf[1024];		/* formatting buffer */
/*
 * Check that the application schema is an existing regular file.
 */
	if (stat(appfile, &fileinfo)) {
		sprintf(ebuf, "Application schema \"%s\"\n", appfile);
		xmpi_error(0, ebuf);
		return(0);
	}

	if (!S_ISREG(fileinfo.st_mode)) {
		sprintf(ebuf,
			"Application schema \"%s\"\n: Is not a regular file",
			appfile);
		errno = 0;
		xmpi_error(0, ebuf);
		return(0);
	}
/*
 * Parse it.
 */	
	appd = asc_parse(appfile, &lineno, 0);

	if (appd == 0) {
		if (lineno > 0) {
			sprintf(ebuf,
				"Parsing application schema \"%s\"\nline %d",
				appfile, lineno);
		} else {
			sprintf(ebuf, "Parsing application schema \"%s\"\n",
				appfile);
		}

		xmpi_error(0, ebuf);
		return(0);
	}

	return(appd);
}

/*
 *	xmpi_asc_free
 *
 *	Function:	- free an application schema descriptor
 *	Accepts:	- app. schema desc.
 */
void
xmpi_asc_free(appd)

LIST			*appd;

{
	asc_free(appd);
}
