/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_error.c,v 1.2 1999/11/08 06:20:24 bbarrett Exp $
 *
 *	Function:	- error dialog
 */

#define _NO_PROTO

#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <X11/cursorfont.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "lam.h"
#include "xmpi.h"

/*
 * global functions
 */
void			xmpi_error();

/*
 * external functions
 */
extern void		itoa();

/*
 * local functions
 */
static char 		*errorstr();

/*
 * local variables
 */
#define BUFLEN		1024
#define MAXERRMSGLEN	64

static char		buffer[BUFLEN];		/* complete message */
static char		*errmsg[] = {
		"improper command invocation",	/* EUSAGE */
		"delete from list failed",	/* EDELETE */
		"bad magic number",		/* EMAGIC */
		"invalid ID specification",	/* EBADIDSPEC */
		"impossible, ergo a bug",	/* EIMPOSSIBLE */
			};

/*
 *	xmpi_error
 *
 *	Function:	- widget child of the desired centering shell
 *			  displays error message in dialog
 *			- displays appended user and system error message
 *	Accepts:	- parent widget (or NULL)
 *			- user error message
 */
void
xmpi_error(w, usrmsg)

Widget			w;
char			*usrmsg;

{
	Widget		dialog_w;
	XmString	str;
	Arg		args[3];

	w = (w == 0) ? xmpi_shell : xmpi_wmshell(w);

	str = XmStringCreateLtoR(errorstr(usrmsg), XmSTRING_DEFAULT_CHARSET);

	XtSetArg(args[0], XmNmessageString, str);
	XtSetArg(args[1], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
	XtSetArg(args[2], XmNautoUnmanage, False);
	dialog_w = XmCreateErrorDialog(w, "error_pop", args, 3);
	XmStringFree(str);
	XtAddCallback(dialog_w, XmNokCallback,
			(XtCallbackProc) XtDestroyWidget, NULL);
	XtUnmanageChild(XmMessageBoxGetChild(dialog_w, XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog_w,
			XmDIALOG_CANCEL_BUTTON));
	XtManageChild(dialog_w);
	XtPopup(XtParent(dialog_w), XtGrabNone);
}

/*
 *	errorstr
 *
 *	Function:	- forms XMPI error message
 *			- uses system dependent and UNIX error message tables
 *			- returned message is stored in a static buffer
 *	Accepts:	- user's error message
 *	Returns:	- extended error message
 */
static char *
errorstr(msg)

char			*msg;

{
	char		anum[16];		/* ascii error code */
	char		*syserr;		/* system dep. error string */

	buffer[0] = '\0';
/*
 * Check for specific XMPI errors first.
 */
	if (msg && *msg) {
		strncpy(buffer, msg, BUFLEN - MAXERRMSGLEN);
	}

	if (XMPI_ERR_LOW <= errno && errno <= XMPI_ERR_HIGH) {
		strcat(buffer, ": ");
		strcat(buffer, errmsg[errno - XMPI_ERR_LOW]);
	}
/*
 * Pass through to system dependent error message routine.
 */
	else {
		syserr = xmpi_sys_errorstr(errno);

		if (syserr) {
			strcat(buffer, ": ");
			strcat(buffer, syserr);
		} else {
			if (errno != 0) {
				strcat(buffer,": Unknown error ");
				itoa(errno, anum);
				strcat(buffer, anum);
			}
		}
	}

	return(buffer);
}
