/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : allpassi.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitAllPassNetworkInt
|
| Description : DSPKitAllPassNetworkInt
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char allpassi_cc [] = "$Id$";

#include "allpassi.h"

DSPKitAllPassNetworkInt::DSPKitAllPassNetworkInt ()
{
  reverbTime = 2.0;
  delayTime  = 0.1;
  g = pow (0.001,delayTime / reverbTime);
}

long DSPKitAllPassNetworkInt::setInputAndDelayTime
  (DSPKitProcessor *ip, double dt)
{
  delayTime  = dt;
  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  mux1.setInput (ip);
  amp1.setInput (&mux1);
  amp1.setGain (-g);
  sum.setInput (&amp1);
  feedback.setInput (&mux1);
  feedback.setFeedbackTime (reverbTime);
  delay.setInputAndDelayTime (&feedback,delayTime,1);
  mux2.setInput (&delay);
  amp2.setInput (&mux2);
  amp2.setGain (1.0 - g*g);
  sum.addInput (&amp2);
  amp3.setInput (&mux2);
  amp3.setGain (g);
  feedback.setFeedbackInput (&amp3);
  return DSPKitProcessor::setInput (&sum);
}

long DSPKitAllPassNetworkInt::setModInput (DSPKitProcessor *mip)
{
  return delay.setModInput (mip);
}

void DSPKitAllPassNetworkInt::setG (double newG)
{
  if (newG <= 0.0)
    g = 0.00001;
  else if (newG >= 1.0)
    g = 0.99999;
  else
    g = newG;

  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  feedback.setFeedbackTime (reverbTime);
  amp1.setGain (-g);
  amp2.setGain (1.0 - g*g);
  amp3.setGain (g);
}

void DSPKitAllPassNetworkInt::setReverbTime (double rt)
{
  reverbTime = rt;
  g = pow (0.001, delayTime / reverbTime);
  feedback.setFeedbackTime (reverbTime);
  amp1.setGain (-g);
  amp2.setGain (1.0 - g*g);
  amp3.setGain (g);
}

/***************************************************************************/
