/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : delayint.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDelayInt
|
| Description : DSPKitDelayInt
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_DELAYINT_H_
#define _DSPKIT_DELAYINT_H_

#include "processo.h"

class DSPKitDelayInt : public DSPKitProcessor
{
  public:

    DSPKitDelayInt ();
    ~DSPKitDelayInt ();
    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    long setInputAndDelayTime (DSPKitProcessor *ip,double dt,long feedback);
    long setModInput (DSPKitProcessor *ip);
    long getSample (double &outputSample);

  protected:

    double getOutput (long currentSampleIndex);
    
    DSPKitProcessor *modInput;
    double          delayTime;
    double          *buffer;
    long            bufSize;
    long            currentSampleIndex;
    long            lastSampleIndex;
    long            haveSamples;
    long            endOfInput;
};

#endif

/***************************************************************************/
