/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : feedback.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitFeedback
|
| Description : DSPKitFeedback
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_FEEDBACK_H_
#define _DSPKIT_FEEDBACK_H_

#include "processo.h"

class DSPKitFeedback : public DSPKitProcessor
{
  public:

    long setInput (DSPKitProcessor *ip);
    void setFeedbackInput (DSPKitProcessor *fip);
    void setFeedbackTime (double t);
    long getSample (double &outputSample);
    double getFeedbackTime () const;
    DSPKitProcessor *getFeedbackInput ();
    
  protected:

    DSPKitProcessor *feedbackInput;
    double          feedbackTime;
    long            feedbackSampleCount;
    long            feedbackSampleIndex;
    long            haveInput;
    long            haveFeedback;
};

inline DSPKitProcessor *DSPKitFeedback::getFeedbackInput ()
{
  return feedbackInput;
}

inline double DSPKitFeedback::getFeedbackTime () const
{
  return feedbackTime;
}

#endif

/***************************************************************************/
