/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : limiter.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitLimiter
|
| Description : DSPKitLimiter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char limiter_cc [] = "$Id$";

#include "limiter.h"

void DSPKitLimiter::scaleBuffer ()
{
  double scale;
  double scale1;
  double scale2;
  double scaleIncrement;
  long i;
  
  i = writeIndex;

  if (absMax1 <= threshold && absMax2 <= threshold) return;

  if (absMax1 > threshold)
    scale1 = threshold / absMax1;
  else
    scale1 = 1.0;

  if (absMax2 > threshold)
    scale2 = threshold / absMax2;
  else
    scale2 = 1.0;

  scaleIncrement = (scale2 - scale1) / inputBufSize;

  scale = scale1;
  
  while (i != processIndex)
  {
    sampleBuffer [i] *= scale;
    i++;
    i %= bufSize;
    if (i == 0) scale += scaleIncrement;
  }
}

/***************************************************************************/
