/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : resonato.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitResonator
|
| Description : DSPKitResonator
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_RESONATOR_H_
#define _DSPKIT_RESONATOR_H_

#include "processo.h"

typedef struct DBBuffer
{
  double y1;
  double y2;

} DBBuffer;

class DSPKitResonator : public DSPKitProcessor
{
  public:

    long setInput (DSPKitProcessor *ip);
    void setCenterFreqAndBW (double f,double bw);
    long getSample (double &outputSample);
    
  protected:

    double   centerFreq;
    double   bandwidth;
    double   C;
    double   a0;
    double   b1;
    double   b2;
    DBBuffer chBuf;
};

#endif

/***************************************************************************/
