% -*- SLang -*-
%
% run compiler in a subshell and/or parse error messages
%
% Changes made by Alexander Demenshin <aldem@barnet.kharkov.ua>
%
% functions:
%   compile_parse_errors		parse next error
%   compile_previous_error		parse previous error
%   compile_parse_buf    		parse current buffer as error messages
%   compile			        run program and parse it output

% The file also contains a database for various compilers.
% This file reads the function from the database at the bottom of the file

%!% compiler name in the database "compile.sl"
!if (is_defined ("compile_parse_error_function"))
  variable compile_parse_error_function = Null_String;

%!% regular expression to extract compile errors
!if (is_defined ("compile_parse_regexp"))
  variable compile_parse_regexp = Null_String;

variable Compile_Output_Buffer = "*shell-output*";

if (is_defined ("get_process_input"))
{
   Compile_Output_Buffer = "*compile*";
}

% Assigning global variables like this is nolonger necessary.

$4 = "'compile_parse_error_function' needs set.  See jed.rc for info.";
$5 = "compile.sl";
$6 = " *compile.sl*";
$7 = "%s not found!";
$8 = "Compiler type not found in database file %s";

!if (strlen (compile_parse_regexp))
{
   !if (strlen (compile_parse_error_function))
     error ($4);
   compile_parse_error_function = strlow (compile_parse_error_function);

   $1 = whatbuf ();
   $2 = expand_jedlib_file ($5);
   !if (strlen($2)) verror ($7, $5);	% shouldn't happen

   setbuf ($6);
   $3 = insert_file_region ($2, 
			    "%@" + compile_parse_error_function + ";",
			    "----");
   if ($3 > 0) evalbuffer ();
   delbuf (whatbuf);
   setbuf ($1);
   if ($3 <= 0)
     verror ($8, $5);
}

$1 = 0; $2 = 0; $3 = 0; $4 = 0; $5 = 0; $6 = 0; $7 = 0; $8 = 0;

variable Compile_Src_Dir = Null_String;
variable Compile_Line_Mark = 0;

%
%  These variables are used when parsing GNU's Make output (directory changes).
%  I don't know what kind of output generated by other Make, so substitute
%  it if needed. <aldem>
%
#ifdef UNIX
variable Compile_Dir_Enter = "^g?make\\[\\d+\\]: Entering directory `\\(.+\\)'";
variable Compile_Dir_Leave = "^g?make\\[\\d+\\]: Leaving directory `\\(.+\\)'";

define compile_parse_make_chdir ()
{
   variable beg_mark, end_mark;
   variable end_line;

   push_spot ();
   EXIT_BLOCK
     {
	pop_spot ();
     }

   beg_mark = create_user_mark ();
   end_mark = create_user_mark ();

   forever
     {
	goto_user_mark (end_mark);

	end_line = 0;

	if (re_bsearch (Compile_Dir_Leave))
	  {
	     if (up_1 ())
	       end_line = what_line ();

	     move_user_mark (end_mark);
	  }

	goto_user_mark (beg_mark);

	!if (up_1 ()) return Null_String;

	if (re_bsearch (Compile_Dir_Enter))
	  {
	     if (not(end_line)
		 or (what_line () > end_line))
	       break;
	     move_user_mark (beg_mark);
	  }
	else return Null_String;
     }
   regexp_nth_match (1);
}

#endif

define compile_find_file (file, line)
{
#ifdef UNIX
   variable dir;

   dir = compile_parse_make_chdir ();
   if (strlen (dir) and (file[0] != '/'))
     file = dircat (dir, file);
#endif

   if (1 != file_status (file))
     {
	file = Compile_Src_Dir + file;
	while (1 != file_status (file))
	  {
	     file = read_file_from_mini ("Find this file's errors:");
	  }
     }

   (Compile_Src_Dir,) = parse_filename (file);

   () = find_file (file);
   widen_buffer ();
   goto_line (line);
   bol_skip_white ();
}

define compile_parse_errors_dir (next_error_fun, next_line_fun)
{
   variable cbuf, obuf = Compile_Output_Buffer;
   variable line, file;

   Compile_Line_Mark = 0;

   !if (bufferp(obuf))
     {
	flush ("Did you compile?");
	return;
     }

   if (MINIBUFFER_ACTIVE) return;

   cbuf = pop2buf_whatbuf (obuf);

   if (@next_error_fun ())
     {
	file = regexp_nth_match (1);	% file name
	line = regexp_nth_match (2);	% line number (string)
	!if (strlen (line)) return;

	bol();
	Compile_Line_Mark = create_line_mark (3);

	@next_line_fun ();

	compile_find_file (file, integer (line));
	cbuf = whatbuf ();
	sw2buf (obuf);
     }

   pop2buf (cbuf);
}

define compile_find_next_error_fun ()
{
   eol ();
   if (eobp ())
     {
	message ("No more errors!");
	return 0;
     }

   bol ();
   !if (re_fsearch (compile_parse_regexp))
     {
	eob ();
	return 0;
     }

   1;
}

define compile_find_prev_error_fun ()
{
   bol ();
   if (bobp ())
     {
	message ("No more errors!");
	0;
     }

   !if (re_bsearch (compile_parse_regexp))
     {
	bob ();
	return 0;
     }

   1;
}

define compile_parse_errors ()
{
   compile_parse_errors_dir (&compile_find_next_error_fun, &go_down_1);
}

define compile_previous_error ()
{
   compile_parse_errors_dir (&compile_find_prev_error_fun, &bol);
}

define compile ()
{
   variable b, n;
   variable cmd = NULL;
   
   if (_NARGS != 0)
     cmd = ();

   b = whatbuf();
   call ("save_buffers");

   if (cmd == NULL) do_shell_cmd ();
   else shell_perform_cmd (cmd);

   bob();
   pop2buf(b);

   compile_parse_errors ();
}

%
%  Parse current buffer as error output
%
define compile_parse_buf ()
{
   Compile_Output_Buffer = whatbuf();
   bob ();
   compile_parse_errors ();
}

$1 = "acompile.sl";
if (is_defined ("get_process_input"))
{
   () = evalfile ($1);
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This is a database of regular expressions for extracting information
% generated by various compilers.
% It is used by "compile.sl"
% Find the function for your compiler and reference it in your jed.rc file.
%
% Currently supported compilers:
%
%     bcc/tcc, Ultrix_cc, gcc, hp_cc, aix/xlc/xlf, wcc
#iffalse	% don't evaluate database directly
--------------------------------------------------------------------------
Borland bcc/tcc compilers
Error foo.c 4: Undefined symbol 'x' in function main
Warning foo.c 34: Possible use of 'y' before definition in function main

%@bcc;
%@tcc;
compile_parse_regexp = "^[EW][a-r]+ \\(.+\\) \\(\\d+\\):";
--------------------------------------------------------------------------
Ultrix cc compiler
ccom: Error: t.c, line 14: LC_ALL undefined

%@ultrix_cc;
compile_parse_regexp = "Error: +\\(.+\\)\\\", line \\(\\d+\\):";
--------------------------------------------------------------------------
hp cc compiler
cc: "t.c", line 3: error 1588: "ddkldkjdldkj" undefined.

%@hp_cc;
compile_parse_regexp = "^cc: +\\\"\\(.+\\)\\\", line \\(\\d+\\):";
--------------------------------------------------------------------------
Sun acc compiler
"filename.c", line 123: error: buffer undefined
"filename.c", line 123: warning: fin not used

%@sun_acc;
compile_parse_regexp = "^\\\"\\(.+\\)\\\", line \\(\\d+\\):";
--------------------------------------------------------------------------
AIX compiler, which may be referenced under any of these names.
The Fortran compiler has the same format, so allow that too
"foo.c", line 13.4: 1506-045 (S) Undeclared identifier bar.
"foo.f", line 21.20: 1515-019 (S) Syntax is incorrect.

%@aix;
%@xlc;
%@xlf;
compile_parse_regexp = "^\\\"\\(.+\\)\\\", line \\(\\d+\\)\\.";
--------------------------------------------------------------------------
The GNU cc compiler
cmds.c:33: warning: initialization of non-const * pointer...
cmds.c:1041 (cmds.o): Undefined symbol _Screen_Height referenced...
In file included from /usr/local/src/jed/src/xterm.c:10:

%@gcc;
compile_parse_regexp = "^\\([^ ]+\\):\\(\\d+\\) ?(?.*)?:";
--------------------------------------------------------------------------
The WATCOM compiler wcc
keymap.c(71): Error! E1011: Symbol 'show_memory' has not been declared
event.c(22): Warning! W202: Symbol 'xx' has been defined, but not referenced
Warning(1028): PhGetMsgSize_ is an undefined reference
file event.o(/home/qnx/rwm/photon/event.c): undefined symbol PhAttach_

%@wcc;
compile_parse_regexp = "^\\(.+\\)(\\(\\d+\\)): [EW].+[rg]! [EW]\d+:.*";
--------------------------------------------------------------------------
The Java compiler javac
Test.java:151: Method getNumber() not found in class java.lang.String.

%@javac;
compile_parse_regexp = "^\\(.+\\):\\(\\d+\\):";
--------------------------------------------------------------------------
Microsoft Visual C
cob.cpp(30) : warning C4091: no symbols were declared
cob.cpp(32) : error C2665: 'COBFileHeader::COBFileHeader' : none of the
2 overloads can convert parameter 1 from type 'char [34]' (new behavior;
please see help)
cob.cpp(38) : warning C4091: no symbols were declared
cob.cpp(45) : warning C4091: no symbols were declared
cob.cpp(50) : error C2239: unexpected token '{' following declaration of
'COBChunkHead'
%@vc;
compile_parse_regexp = "^\\(.+\\)(\\(\\d+\\)) : [ew].+:.*";
--------------------------------------------------------------------------
#endif	% don't evaluate database directly
%%%%%%%%%%%%%%%%%%%%%%%%%%% end-of-file (SLang) %%%%%%%%%%%%%%%%%%%%%%%%%%
