; -*- coding: iso-2022-7bit  -*-
;;; ujisx0201.el --- tables between UCS and JIS X 0201

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from JIX0201.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'latin-jisx0201 'unicode 'jis-x-0201-latin-vs-unicode-assoc)
(put 'katakana-jisx0201 'unicode 'jis-x-0201-katakana-vs-unicode-assoc)

(defvar
  jis-x-0201-latin-vs-unicode-assoc
  (list
   'assoc
   '(char-1 . ucs-generic)
   (mapcar
    (lambda (x)
      (cons (make-char 'latin-jisx0201 (car x))
	    (cdr x)))
    '((?\x21 . ?\x0021) ;; EXCLAMATION MARK
      (?\x22 . ?\x0022) ;; QUOTATION MARK
      (?\x23 . ?\x0023) ;; NUMBER SIGN
      (?\x24 . ?\x0024) ;; DOLLAR SIGN
      (?\x25 . ?\x0025) ;; PERCENT SIGN
      (?\x26 . ?\x0026) ;; AMPERSAND
      (?\x27 . ?\x0027) ;; APOSTROPHE
      (?\x28 . ?\x0028) ;; LEFT PARENTHESIS
      (?\x29 . ?\x0029) ;; RIGHT PARENTHESIS
      (?\x2A . ?\x002A) ;; ASTERISK
      (?\x2B . ?\x002B) ;; PLUS SIGN
      (?\x2C . ?\x002C) ;; COMMA
      (?\x2D . ?\x002D) ;; HYPHEN-MINUS
      (?\x2E . ?\x002E) ;; FULL STOP
      (?\x2F . ?\x002F) ;; SOLIDUS
      (?\x30 . ?\x0030) ;; DIGIT ZERO
      (?\x31 . ?\x0031) ;; DIGIT ONE
      (?\x32 . ?\x0032) ;; DIGIT TWO
      (?\x33 . ?\x0033) ;; DIGIT THREE
      (?\x34 . ?\x0034) ;; DIGIT FOUR
      (?\x35 . ?\x0035) ;; DIGIT FIVE
      (?\x36 . ?\x0036) ;; DIGIT SIX
      (?\x37 . ?\x0037) ;; DIGIT SEVEN
      (?\x38 . ?\x0038) ;; DIGIT EIGHT
      (?\x39 . ?\x0039) ;; DIGIT NINE
      (?\x3A . ?\x003A) ;; COLON
      (?\x3B . ?\x003B) ;; SEMICOLON
      (?\x3C . ?\x003C) ;; LESS-THAN SIGN
      (?\x3D . ?\x003D) ;; EQUALS SIGN
      (?\x3E . ?\x003E) ;; GREATER-THAN SIGN
      (?\x3F . ?\x003F) ;; QUESTION MARK
      (?\x40 . ?\x0040) ;; COMMERCIAL AT
      (?\x41 . ?\x0041) ;; LATIN CAPITAL LETTER A
      (?\x42 . ?\x0042) ;; LATIN CAPITAL LETTER B
      (?\x43 . ?\x0043) ;; LATIN CAPITAL LETTER C
      (?\x44 . ?\x0044) ;; LATIN CAPITAL LETTER D
      (?\x45 . ?\x0045) ;; LATIN CAPITAL LETTER E
      (?\x46 . ?\x0046) ;; LATIN CAPITAL LETTER F
      (?\x47 . ?\x0047) ;; LATIN CAPITAL LETTER G
      (?\x48 . ?\x0048) ;; LATIN CAPITAL LETTER H
      (?\x49 . ?\x0049) ;; LATIN CAPITAL LETTER I
      (?\x4A . ?\x004A) ;; LATIN CAPITAL LETTER J
      (?\x4B . ?\x004B) ;; LATIN CAPITAL LETTER K
      (?\x4C . ?\x004C) ;; LATIN CAPITAL LETTER L
      (?\x4D . ?\x004D) ;; LATIN CAPITAL LETTER M
      (?\x4E . ?\x004E) ;; LATIN CAPITAL LETTER N
      (?\x4F . ?\x004F) ;; LATIN CAPITAL LETTER O
      (?\x50 . ?\x0050) ;; LATIN CAPITAL LETTER P
      (?\x51 . ?\x0051) ;; LATIN CAPITAL LETTER Q
      (?\x52 . ?\x0052) ;; LATIN CAPITAL LETTER R
      (?\x53 . ?\x0053) ;; LATIN CAPITAL LETTER S
      (?\x54 . ?\x0054) ;; LATIN CAPITAL LETTER T
      (?\x55 . ?\x0055) ;; LATIN CAPITAL LETTER U
      (?\x56 . ?\x0056) ;; LATIN CAPITAL LETTER V
      (?\x57 . ?\x0057) ;; LATIN CAPITAL LETTER W
      (?\x58 . ?\x0058) ;; LATIN CAPITAL LETTER X
      (?\x59 . ?\x0059) ;; LATIN CAPITAL LETTER Y
      (?\x5A . ?\x005A) ;; LATIN CAPITAL LETTER Z
      (?\x5B . ?\x005B) ;; LEFT SQUARE BRACKET
      (?\x5C . ?\x00A5) ;; YEN SIGN
      (?\x5D . ?\x005D) ;; RIGHT SQUARE BRACKET
      (?\x5E . ?\x005E) ;; CIRCUMFLEX ACCENT
      (?\x5F . ?\x005F) ;; LOW LINE
      (?\x60 . ?\x0060) ;; GRAVE ACCENT
      (?\x61 . ?\x0061) ;; LATIN SMALL LETTER A
      (?\x62 . ?\x0062) ;; LATIN SMALL LETTER B
      (?\x63 . ?\x0063) ;; LATIN SMALL LETTER C
      (?\x64 . ?\x0064) ;; LATIN SMALL LETTER D
      (?\x65 . ?\x0065) ;; LATIN SMALL LETTER E
      (?\x66 . ?\x0066) ;; LATIN SMALL LETTER F
      (?\x67 . ?\x0067) ;; LATIN SMALL LETTER G
      (?\x68 . ?\x0068) ;; LATIN SMALL LETTER H
      (?\x69 . ?\x0069) ;; LATIN SMALL LETTER I
      (?\x6A . ?\x006A) ;; LATIN SMALL LETTER J
      (?\x6B . ?\x006B) ;; LATIN SMALL LETTER K
      (?\x6C . ?\x006C) ;; LATIN SMALL LETTER L
      (?\x6D . ?\x006D) ;; LATIN SMALL LETTER M
      (?\x6E . ?\x006E) ;; LATIN SMALL LETTER N
      (?\x6F . ?\x006F) ;; LATIN SMALL LETTER O
      (?\x70 . ?\x0070) ;; LATIN SMALL LETTER P
      (?\x71 . ?\x0071) ;; LATIN SMALL LETTER Q
      (?\x72 . ?\x0072) ;; LATIN SMALL LETTER R
      (?\x73 . ?\x0073) ;; LATIN SMALL LETTER S
      (?\x74 . ?\x0074) ;; LATIN SMALL LETTER T
      (?\x75 . ?\x0075) ;; LATIN SMALL LETTER U
      (?\x76 . ?\x0076) ;; LATIN SMALL LETTER V
      (?\x77 . ?\x0077) ;; LATIN SMALL LETTER W
      (?\x78 . ?\x0078) ;; LATIN SMALL LETTER X
      (?\x79 . ?\x0079) ;; LATIN SMALL LETTER Y
      (?\x7A . ?\x007A) ;; LATIN SMALL LETTER Z
      (?\x7B . ?\x007B) ;; LEFT CURLY BRACKET
      (?\x7C . ?\x007C) ;; VERTICAL LINE
      (?\x7D . ?\x007D) ;; RIGHT CURLY BRACKET
      (?\x7E . ?\x203E) ;; OVERLINE
      ))))

(defvar
  jis-x-0201-katakana-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?(I!(B . ?\xFF61) ;; HALFWIDTH IDEOGRAPHIC FULL STOP
     (?(I"(B . ?\xFF62) ;; HALFWIDTH LEFT CORNER BRACKET
     (?(I#(B . ?\xFF63) ;; HALFWIDTH RIGHT CORNER BRACKET
     (?(I$(B . ?\xFF64) ;; HALFWIDTH IDEOGRAPHIC COMMA
     (?(I%(B . ?\xFF65) ;; HALFWIDTH KATAKANA MIDDLE DOT
     (?(I&(B . ?\xFF66) ;; HALFWIDTH KATAKANA LETTER WO
     (?(I'(B . ?\xFF67) ;; HALFWIDTH KATAKANA LETTER SMALL A
     (?(I((B . ?\xFF68) ;; HALFWIDTH KATAKANA LETTER SMALL I
     (?(I)(B . ?\xFF69) ;; HALFWIDTH KATAKANA LETTER SMALL U
     (?(I*(B . ?\xFF6A) ;; HALFWIDTH KATAKANA LETTER SMALL E
     (?(I+(B . ?\xFF6B) ;; HALFWIDTH KATAKANA LETTER SMALL O
     (?(I,(B . ?\xFF6C) ;; HALFWIDTH KATAKANA LETTER SMALL YA
     (?(I-(B . ?\xFF6D) ;; HALFWIDTH KATAKANA LETTER SMALL YU
     (?(I.(B . ?\xFF6E) ;; HALFWIDTH KATAKANA LETTER SMALL YO
     (?(I/(B . ?\xFF6F) ;; HALFWIDTH KATAKANA LETTER SMALL TU
     (?(I0(B . ?\xFF70) ;; HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
     (?(I1(B . ?\xFF71) ;; HALFWIDTH KATAKANA LETTER A
     (?(I2(B . ?\xFF72) ;; HALFWIDTH KATAKANA LETTER I
     (?(I3(B . ?\xFF73) ;; HALFWIDTH KATAKANA LETTER U
     (?(I4(B . ?\xFF74) ;; HALFWIDTH KATAKANA LETTER E
     (?(I5(B . ?\xFF75) ;; HALFWIDTH KATAKANA LETTER O
     (?(I6(B . ?\xFF76) ;; HALFWIDTH KATAKANA LETTER KA
     (?(I7(B . ?\xFF77) ;; HALFWIDTH KATAKANA LETTER KI
     (?(I8(B . ?\xFF78) ;; HALFWIDTH KATAKANA LETTER KU
     (?(I9(B . ?\xFF79) ;; HALFWIDTH KATAKANA LETTER KE
     (?(I:(B . ?\xFF7A) ;; HALFWIDTH KATAKANA LETTER KO
     (?(I;(B . ?\xFF7B) ;; HALFWIDTH KATAKANA LETTER SA
     (?(I<(B . ?\xFF7C) ;; HALFWIDTH KATAKANA LETTER SI
     (?(I=(B . ?\xFF7D) ;; HALFWIDTH KATAKANA LETTER SU
     (?(I>(B . ?\xFF7E) ;; HALFWIDTH KATAKANA LETTER SE
     (?(I?(B . ?\xFF7F) ;; HALFWIDTH KATAKANA LETTER SO
     (?(I@(B . ?\xFF80) ;; HALFWIDTH KATAKANA LETTER TA
     (?(IA(B . ?\xFF81) ;; HALFWIDTH KATAKANA LETTER TI
     (?(IB(B . ?\xFF82) ;; HALFWIDTH KATAKANA LETTER TU
     (?(IC(B . ?\xFF83) ;; HALFWIDTH KATAKANA LETTER TE
     (?(ID(B . ?\xFF84) ;; HALFWIDTH KATAKANA LETTER TO
     (?(IE(B . ?\xFF85) ;; HALFWIDTH KATAKANA LETTER NA
     (?(IF(B . ?\xFF86) ;; HALFWIDTH KATAKANA LETTER NI
     (?(IG(B . ?\xFF87) ;; HALFWIDTH KATAKANA LETTER NU
     (?(IH(B . ?\xFF88) ;; HALFWIDTH KATAKANA LETTER NE
     (?(II(B . ?\xFF89) ;; HALFWIDTH KATAKANA LETTER NO
     (?(IJ(B . ?\xFF8A) ;; HALFWIDTH KATAKANA LETTER HA
     (?(IK(B . ?\xFF8B) ;; HALFWIDTH KATAKANA LETTER HI
     (?(IL(B . ?\xFF8C) ;; HALFWIDTH KATAKANA LETTER HU
     (?(IM(B . ?\xFF8D) ;; HALFWIDTH KATAKANA LETTER HE
     (?(IN(B . ?\xFF8E) ;; HALFWIDTH KATAKANA LETTER HO
     (?(IO(B . ?\xFF8F) ;; HALFWIDTH KATAKANA LETTER MA
     (?(IP(B . ?\xFF90) ;; HALFWIDTH KATAKANA LETTER MI
     (?(IQ(B . ?\xFF91) ;; HALFWIDTH KATAKANA LETTER MU
     (?(IR(B . ?\xFF92) ;; HALFWIDTH KATAKANA LETTER ME
     (?(IS(B . ?\xFF93) ;; HALFWIDTH KATAKANA LETTER MO
     (?(IT(B . ?\xFF94) ;; HALFWIDTH KATAKANA LETTER YA
     (?(IU(B . ?\xFF95) ;; HALFWIDTH KATAKANA LETTER YU
     (?(IV(B . ?\xFF96) ;; HALFWIDTH KATAKANA LETTER YO
     (?(IW(B . ?\xFF97) ;; HALFWIDTH KATAKANA LETTER RA
     (?(IX(B . ?\xFF98) ;; HALFWIDTH KATAKANA LETTER RI
     (?(IY(B . ?\xFF99) ;; HALFWIDTH KATAKANA LETTER RU
     (?(IZ(B . ?\xFF9A) ;; HALFWIDTH KATAKANA LETTER RE
     (?(I[(B . ?\xFF9B) ;; HALFWIDTH KATAKANA LETTER RO
     (?(I\(B . ?\xFF9C) ;; HALFWIDTH KATAKANA LETTER WA
     (?(I](B . ?\xFF9D) ;; HALFWIDTH KATAKANA LETTER N
     (?(I^(B . ?\xFF9E) ;; HALFWIDTH KATAKANA VOICED SOUND MARK
     (?(I_(B . ?\xFF9F) ;; HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
     )))

(provide 'ujisx0201)
 
 